<?php
/**
 * The Header for our theme.
 * @package Master Study Lite
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
  <meta charset="<?php bloginfo( 'charset' ); ?>">
  <meta name="viewport" content="width=device-width">
  <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
  <?php if ( function_exists( 'wp_body_open' ) ) {
    wp_body_open();
  } else {
    do_action( 'wp_body_open' );
  } ?>
  <?php if(get_theme_mod('master_study_lite_preloader',false) != '' || get_theme_mod( 'master_study_lite_display_preloader',false) != ''){ ?>
    <div class="frame w-100 h-100">
      <div class="loader">
        <div class="dot-1"></div>
        <div class="dot-2"></div>
        <div class="dot-3"></div>
      </div>
    </div>
  <?php }?>
<header role="banner" class="header-box">
  <a class="screen-reader-text skip-link" href="#skip_content"><?php esc_html_e( 'Skip to content', 'master-study-lite' ); ?></a>
  <?php if( get_theme_mod( 'master_study_lite_topbar_hide',false) != '') { ?>
    <div class="topbar">
      <div class="container">
        <div class="row">
          <div class="col-xl-3 col-lg-3 col-md-3 col-12 align-self-center py-2">
            <?php if(get_theme_mod('master_study_lite_top_sidebar_phone_number') != ''){ ?>
              <div class="phone d-flex align-items-center gap-2">
                <i class="<?php echo esc_attr(get_theme_mod('master_study_lite_top_sidebar_phone_no_icon','fas fa-phone')); ?>"></i><p class="mb-0"><a href="tel:<?php echo esc_attr( get_theme_mod('master_study_lite_top_sidebar_phone_number') ); ?>"><?php echo esc_html(get_theme_mod('master_study_lite_top_sidebar_phone_number'));?></a></p>
              </div>
            <?php }?>
          </div>
          <div class="col-xl-3 col-lg-3 col-md-3 col-12 align-self-center py-2">
            <?php if(get_theme_mod('master_study_lite_top_sidebar_email_address') != ''){ ?>
              <div class="mail d-flex align-items-center gap-2">
                <i class="<?php echo esc_attr(get_theme_mod('master_study_lite_top_sidebar_email_address_icon','fa-solid fa-envelope-open-text')); ?>"></i><p class="mb-0"><a href="mailto:<?php echo esc_attr(get_theme_mod('master_study_lite_top_sidebar_email_address'));?>"><?php echo esc_html(get_theme_mod('master_study_lite_top_sidebar_email_address'));?></a></p>
              </div>
            <?php }?>
          </div>
          <div class="col-xl-6 col-lg-6 col-md-6 col-12 align-self-end text-end">
            <div class="social-icon">
              <?php if(get_theme_mod('master_study_lite_facebook_url') != ''){ ?>
                <a target="_blank" href="<?php echo esc_url(get_theme_mod('master_study_lite_facebook_url')); ?>"><i class="<?php echo esc_attr(get_theme_mod('master_study_lite_facebook_icon','fab fa-facebook-f')); ?>"></i><span class="screen-reader-text"><?php echo esc_html('Facebook', 'master-study-lite'); ?></span></a>
              <?php }?>
              <?php if(get_theme_mod('master_study_lite_twitter_url') != ''){ ?>
                <a target="_blank" href="<?php echo esc_url(get_theme_mod('master_study_lite_twitter_url')); ?>"><i class="<?php echo esc_attr(get_theme_mod('master_study_lite_twitter_icon','fa-brands fa-x-twitter')); ?>"></i><span class="screen-reader-text"><?php echo esc_html('Twitter', 'master-study-lite'); ?></span></a>
              <?php }?>
              <?php if(get_theme_mod('master_study_lite_instagram_url') != ''){ ?>
                <a target="_blank" href="<?php echo esc_url(get_theme_mod('master_study_lite_instagram_url')); ?>"><i class="<?php echo esc_attr(get_theme_mod('master_study_lite_instagram_icon','fab fa-instagram')); ?>"></i><span class="screen-reader-text"><?php echo esc_html('Instagram', 'master-study-lite'); ?></span></a>
              <?php }?>
            </div>
          </div>
        </div>
      </div>
    </div>
  <?php }?>
  <div class="top-header">
    <div class="container">
      <div class="menu-top">
        <div class="row">
          <div class="header-left col-xxl-1 col-xl-1 col-lg-1 col-md-1 col-12 p-0"></div>
          <div class="col-xxl-1 col-xl-2 col-lg-2 col-md-2 col-12 align-self-center logo-box">
            <div class="logo py-2">
              <div class="row">
                <div class="<?php if( get_theme_mod( 'master_study_lite_site_logo_inline') != '') { ?>col-lg-5 col-md-5 col-5<?php } else { ?>col-lg-12 col-md-12 align-self-center<?php } ?>">
                  <?php if ( has_custom_logo() ) : ?>
                    <div class="site-logo"><?php the_custom_logo(); ?></div>
                  <?php endif; ?>
                </div>
                <div class="<?php if( get_theme_mod( 'master_study_lite_site_logo_inline') != '') { ?>col-lg-7 col-md-7 col-7 site-logo-inline"<?php } else { ?>col-lg-12 col-md-12 align-self-center<?php } ?>">
                  <?php $master_study_lite_blog_info = get_bloginfo( 'name' ); ?>
                  <?php if ( ! empty( $master_study_lite_blog_info ) ) : ?>
                    <?php if( get_theme_mod('master_study_lite_site_title_enable',true) != ''){ ?>
                      <?php if ( is_front_page() && is_home() ) : ?>
                        <h1 class="site-title pb-0"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                      <?php else : ?>
                        <p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
                      <?php endif; ?>
                    <?php }?>
                  <?php endif; ?>
                  <?php
                  $master_study_lite_description = get_bloginfo( 'description', 'display' );
                  if ( $master_study_lite_description || is_customize_preview() ) : ?>
                    <?php if( get_theme_mod('master_study_lite_site_tagline_enable',false) != ''){ ?>
                      <p class="site-description"><?php echo esc_html($master_study_lite_description); ?></p>
                    <?php }?>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          </div>
          <div class="col-xxl-10 col-xl-9 col-lg-9 col-md-9 col-12 align-self-center menu-box">
            <div class="navigation-header">
              <div class="toggle-nav mobile-menu">
                <button onclick="master_study_lite_openNav()"><i class="<?php echo esc_attr(get_theme_mod('master_study_lite_responsive_menu_open_icon','fas fa-bars')); ?>"></i></button>
              </div>
              <div id="mySidenav" class="nav sidenav">
                <nav id="site-navigation" class="main-navigation navbar navbar-expand-xl" aria-label="<?php esc_attr_e( 'Top Menu', 'master-study-lite' ); ?>">
                  <?php {
                    wp_nav_menu(
                      array(
                        'theme_location' => 'primary',
                        'menu_class'     => 'menu', 
                        'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                        'fallback_cb' => 'wp_page_menu',
                      )
                    );
                  } ?>
                </nav>
                <a href="javascript:void(0)" class="closebtn mobile-menu" onclick="master_study_lite_closeNav()"><i class="<?php echo esc_attr(get_theme_mod('master_study_lite_responsive_menu_close_icon','fas fa-times')); ?>"></i></a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</header>
