<?php
/**
 * @package Master Study Lite
 * @subpackage master-study-lite
 * @since master-study-lite 1.0
 * Setup the WordPress core custom header feature.
 * @uses master_study_lite_header_style()
*/

function master_study_lite_custom_header_setup() {

	add_theme_support( 'custom-header', apply_filters( 'master_study_lite_custom_header_args', array(
		'default-text-color'     => 'fff',
		'header-text' 			 =>	false,
		'width'                  => 1400,
		'height'                 => 70,
		'flex-width'         	=> true,
        'flex-height'        	=> true,
		'wp-head-callback'       => 'master_study_lite_header_style',
	) ) );
}

add_action( 'after_setup_theme', 'master_study_lite_custom_header_setup' );

if ( ! function_exists( 'master_study_lite_header_style' ) ) :

add_action( 'wp_enqueue_scripts', 'master_study_lite_header_style' );
function master_study_lite_header_style() {
	if ( get_header_image() ) :
	$master_study_lite_custom_css = "
        .top-header{
			background-image:url('".esc_url(get_header_image())."');
			background-position: center top;
			background-size: cover;
		}
		.page-template-home-page .top-header .header-left, .page-template-home-page .top-header .menu-box{
			background-color: transparent;
		}";
	   	wp_add_inline_style( 'master-study-lite-basic-style', $master_study_lite_custom_css );
	endif;
}
endif;