<?php
/**
 * Master Study Lite Theme Customizer
 * @package Master Study Lite
 */

load_template( trailingslashit( get_template_directory() ) . '/inc/logo-sizer.php' );
/**
 * Add postMessage support for site title and description for the Theme Customizer.
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function master_study_lite_customize_register( $wp_customize ) {

	load_template( trailingslashit( get_template_directory() ) . 'inc/custom-control.php' );
	load_template( trailingslashit( get_template_directory() ) . '/inc/icon-changer.php' );

	$wp_customize->add_setting( 'master_study_lite_logo_sizer',array(
		'default' => '',
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control( new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_logo_sizer',array(
		'label' => esc_html__( 'Logo Sizer','master-study-lite' ),
		'section' => 'title_tagline',
		'priority'    => 9,
		'input_attrs' => array(
			'min' => 0,
			'max' => 100,
			'step' => 1,
		),
	))); 

	$wp_customize->add_setting('master_study_lite_site_title_enable',array(
		'default' => true,
		'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
	));
	$wp_customize->add_control('master_study_lite_site_title_enable',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Site Title','master-study-lite'),
		'section' => 'title_tagline'
	));

 	$wp_customize->add_setting('master_study_lite_site_title_font_size',array(
		'default'=> 25,
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control(new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_site_title_font_size',array(
		'label' => esc_html__( 'Site Title Font Size (px)','master-study-lite' ),
		'section'=> 'title_tagline',
		'input_attrs' => array(
         'step' => 1,
			'min'  => 0,
			'max'  => 50,
      ),
	))); 

	// site title color
   $wp_customize->add_setting('master_study_lite_site_title_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_site_title_color', array(
		'label'    => __('Site Title Color', 'master-study-lite'),
		'section'  => 'title_tagline',
		'settings' => 'master_study_lite_site_title_color',
	)));

   $wp_customize->add_setting('master_study_lite_site_tagline_enable',array(
      'default' => false,
      'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
   ));
   $wp_customize->add_control('master_study_lite_site_tagline_enable',array(
      'type' => 'checkbox',
      'label' => __('Enable / Disable Site Tagline','master-study-lite'),
      'section' => 'title_tagline'
   ));

   $wp_customize->add_setting('master_study_lite_site_tagline_font_size',array(
		'default'=> 13,
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control(new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_site_tagline_font_size',array(
		'label' => esc_html__( 'Site Tagline Font Size (px)','master-study-lite' ),
		'section'=> 'title_tagline',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
	)));

	// site tagline color
	$wp_customize->add_setting('master_study_lite_site_tagline_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_site_tagline_color', array(
		'label'    => __('Site Tagline Color', 'master-study-lite'),
		'section'  => 'title_tagline',
		'settings' => 'master_study_lite_site_tagline_color',
	)));

    $wp_customize->add_setting('master_study_lite_site_logo_inline',array(
       'default' => false,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
    ));
    $wp_customize->add_control('master_study_lite_site_logo_inline',array(
       'type' => 'checkbox',
       'label' => __('Site logo inline with site title','master-study-lite'),
       'section' => 'title_tagline',
    ));

    $wp_customize->add_setting('master_study_lite_background_skin',array(
        'default' => 'Without Background',
        'sanitize_callback' => 'master_study_lite_sanitize_choices'
	));
	$wp_customize->add_control('master_study_lite_background_skin',array(
        'type' => 'radio',
        'label' => __('Background Skin','master-study-lite'),
        'description' => __('Here you can add the background skin along with the background image.','master-study-lite'),
        'section' => 'background_image',
        'choices' => array(
            'With Background' => __('With Background Skin','master-study-lite'),
            'Without Background' => __('Without Background Skin','master-study-lite'),
        ),
	) );

	//Important Links
	$wp_customize->add_section( 'master_study_lite_important_links' , array(
    	'title' => esc_html__( 'Important Links', 'master-study-lite' ),
    	'priority' => 10,
	) );

	$wp_customize->add_setting('master_study_lite_doc_link',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('master_study_lite_doc_link',array(
		'type'=> 'hidden',
		'description' => "<a target='_blank' href='". esc_url(MASTER_STUDY_LITE_FREE_DOC) ." '>". esc_html__('Documentation','master-study-lite') ."</a>",
		'section'=> 'master_study_lite_important_links'
	));

	$wp_customize->add_setting('master_study_lite_demo_links',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('master_study_lite_demo_links',array(
		'type'=> 'hidden',
		'description' => "<a target='_blank' href='". esc_url(MASTER_STUDY_LITE_LIVE_DEMO) ." '>". esc_html__('Demo','master-study-lite') ."</a>",
		'section'=> 'master_study_lite_important_links'
	));

	$wp_customize->add_setting('master_study_lite_forum_links',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('master_study_lite_forum_links',array(
		'type'=> 'hidden',
		'description' => "<a target='_blank' href='". esc_url(MASTER_STUDY_LITE_FREE_SUPPORT) ." '>". esc_html__('Support Forum','master-study-lite') ."</a>",
		'section'=> 'master_study_lite_important_links'
	));
	$wp_customize->add_setting('master_study_lite_review_links',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('master_study_lite_review_links',array(
		'type'=> 'hidden',
		'description' => "<a target='_blank' href='". esc_url(MASTER_STUDY_LITE_REVIEW) ." '>". esc_html__('Review','master-study-lite') ."</a>",
		'section'=> 'master_study_lite_important_links'
	));

	//add home page setting pannel
	$wp_customize->add_panel( 'master_study_lite_panel_id', array(
	   'priority' => 11,
	   'capability' => 'edit_theme_options',
	   'theme_supports' => '',
	   'title' => __( 'Theme Settings', 'master-study-lite' ),
	   'description' => __( 'Description of what this panel does.', 'master-study-lite' ),
	) );

	$master_study_lite_font_array = array(
		''                       => 'No Fonts',
		'Abril Fatface'          => 'Abril Fatface',
		'Acme'                   => 'Acme',
		'Anton'                  => 'Anton',
		'Architects Daughter'    => 'Architects Daughter',
		'Arimo'                  => 'Arimo',
		'Arsenal'                => 'Arsenal',
		'Arvo'                   => 'Arvo',
		'Alegreya'               => 'Alegreya',
		'Alfa Slab One'          => 'Alfa Slab One',
		'Averia Serif Libre'     => 'Averia Serif Libre',
		'Bangers'                => 'Bangers',
		'Boogaloo'               => 'Boogaloo',
		'Bad Script'             => 'Bad Script',
		'Bitter'                 => 'Bitter',
		'Bree Serif'             => 'Bree Serif',
		'BenchNine'              => 'BenchNine',
		'Cabin'                  => 'Cabin',
		'Cardo'                  => 'Cardo',
		'Courgette'              => 'Courgette',
		'Cherry Swash'           => 'Cherry Swash',
		'Cormorant Garamond'     => 'Cormorant Garamond',
		'Crimson Text'           => 'Crimson Text',
		'Cuprum'                 => 'Cuprum',
		'Cookie'                 => 'Cookie',
		'Chewy'                  => 'Chewy',
		'Days One'               => 'Days One',
		'Dosis'                  => 'Dosis',
		'Droid Sans'             => 'Droid Sans',
		'Economica'              => 'Economica',
		'Fredoka One'            => 'Fredoka One',
		'Fjalla One'             => 'Fjalla One',
		'Francois One'           => 'Francois One',
		'Frank Ruhl Libre'       => 'Frank Ruhl Libre',
		'Gloria Hallelujah'      => 'Gloria Hallelujah',
		'Great Vibes'            => 'Great Vibes',
		'Handlee'                => 'Handlee',
		'Hammersmith One'        => 'Hammersmith One',
		'Inconsolata'            => 'Inconsolata',
		'Indie Flower'           => 'Indie Flower',
		'IM Fell English SC'     => 'IM Fell English SC',
		'Julius Sans One'        => 'Julius Sans One',
		'Josefin Slab'           => 'Josefin Slab',
		'Josefin Sans'           => 'Josefin Sans',
		'Kanit'                  => 'Kanit',
		'Lobster'                => 'Lobster',
		'Lato'                   => 'Lato',
		'Lora'                   => 'Lora',
		'Libre Baskerville'      => 'Libre Baskerville',
		'Lobster Two'            => 'Lobster Two',
		'Merriweather'           => 'Merriweather',
		'Monda'                  => 'Monda',
		'Montserrat'             => 'Montserrat',
		'Muli'                   => 'Muli',
		'Marck Script'           => 'Marck Script',
		'Noto Serif'             => 'Noto Serif',
		'Open Sans'              => 'Open Sans',
		'Overpass'               => 'Overpass',
		'Overpass Mono'          => 'Overpass Mono',
		'Oxygen'                 => 'Oxygen',
		'Orbitron'               => 'Orbitron',
		'Patua One'              => 'Patua One',
		'Pacifico'               => 'Pacifico',
		'Padauk'                 => 'Padauk',
		'Playball'               => 'Playball',
		'Playfair Display'       => 'Playfair Display',
		'PT Sans'                => 'PT Sans',
		'Philosopher'            => 'Philosopher',
		'Permanent Marker'       => 'Permanent Marker',
		'Poiret One'             => 'Poiret One',
		'Quicksand'              => 'Quicksand',
		'Quattrocento Sans'      => 'Quattrocento Sans',
		'Raleway'                => 'Raleway',
		'Rubik'                  => 'Rubik',
		'Rokkitt'                => 'Rokkitt',
		'Russo One'              => 'Russo One',
		'Righteous'              => 'Righteous',
		'Slabo'                  => 'Slabo',
		'Source Sans Pro'        => 'Source Sans Pro',
		'Shadows Into Light Two' => 'Shadows Into Light Two',
		'Shadows Into Light'     => 'Shadows Into Light',
		'Sacramento'             => 'Sacramento',
		'Shrikhand'              => 'Shrikhand',
		'Tangerine'              => 'Tangerine',
		'Ubuntu'                 => 'Ubuntu',
		'VT323'                  => 'VT323',
		'Varela Round'           => 'Varela Round',
		'Vampiro One'            => 'Vampiro One',
		'Vollkorn'               => 'Vollkorn',
		'Volkhov'                => 'Volkhov',
		'Yanone Kaffeesatz'      => 'Yanone Kaffeesatz'
	);

	//Typography
	$wp_customize->add_section('master_study_lite_typography', array(
		'title'    => __('Typography', 'master-study-lite'),
		'panel'    => 'master_study_lite_panel_id',
	));

	$wp_customize->add_setting('master_study_lite_typography_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('master_study_lite_typography_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','master-study-lite'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','master-study-lite') ."</li><li>". esc_html__('And so on...','master-study-lite') ."</li></ul><a target='_blank' href='". esc_url(MASTER_STUDY_LITE_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','master-study-lite') ."</a>",
   		 'section'=> 'master_study_lite_typography'
 	));

	//This is body FontFamily picker setting
	$wp_customize->add_setting('master_study_lite_body_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_body_color', array(
		'label'    => __('Body Color', 'master-study-lite'),
		'section'  => 'master_study_lite_typography',
		'settings' => 'master_study_lite_body_color',
	)));

	$wp_customize->add_setting('master_study_lite_body_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'master_study_lite_sanitize_choices',
	));
	$wp_customize->add_control(	'master_study_lite_body_font_family', array(
		'section' => 'master_study_lite_typography',
		'label'   => __('Body Fonts', 'master-study-lite'),
		'type'    => 'select',
		'choices' => $master_study_lite_font_array,
	));

	$wp_customize->add_setting('master_study_lite_body_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('master_study_lite_body_font_size', array(
		'label'   => __('Body Font Size', 'master-study-lite'),
		'section' => 'master_study_lite_typography',
		'setting' => 'master_study_lite_body_font_size',
		'type'    => 'text',
	));

	$wp_customize->add_setting('master_study_lite_body_font_weight',array(
		'default' => '',
		'sanitize_callback' => 'master_study_lite_sanitize_choices'
 	));
 	$wp_customize->add_control('master_study_lite_body_font_weight',array(
		'type' => 'select',
		'label' => __('Body Font Weight','master-study-lite'),
		'section' => 'master_study_lite_typography',
		'choices' => array(
		   '100' => __('100','master-study-lite'),
         '200' => __('200','master-study-lite'),
         '300' => __('300','master-study-lite'),
         '400' => __('400','master-study-lite'),
         '500' => __('500','master-study-lite'),
         '600' => __('600','master-study-lite'),
         '700' => __('700','master-study-lite'),
         '800' => __('800','master-study-lite'),
         '900' => __('900','master-study-lite'),
		),
	) );	

	// This is Paragraph Color picker setting
	$wp_customize->add_setting('master_study_lite_paragraph_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_paragraph_color', array(
		'label'    => __('Paragraph Color', 'master-study-lite'),
		'section'  => 'master_study_lite_typography',
		'settings' => 'master_study_lite_paragraph_color',
	)));

	//This is Paragraph FontFamily picker setting
	$wp_customize->add_setting('master_study_lite_paragraph_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'master_study_lite_sanitize_choices',
	));
	$wp_customize->add_control(	'master_study_lite_paragraph_font_family', array(
		'section' => 'master_study_lite_typography',
		'label'   => __('Paragraph Fonts', 'master-study-lite'),
		'type'    => 'select',
		'choices' => $master_study_lite_font_array,
	));

	$wp_customize->add_setting('master_study_lite_paragraph_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('master_study_lite_paragraph_font_size', array(
		'label'   => __('Paragraph Font Size', 'master-study-lite'),
		'section' => 'master_study_lite_typography',
		'setting' => 'master_study_lite_paragraph_font_size',
		'type'    => 'text',
	));

	$wp_customize->add_setting('master_study_lite_paragraph_font_weight',array(
		'default' => '',
		'sanitize_callback' => 'master_study_lite_sanitize_choices'
 	));
 	$wp_customize->add_control('master_study_lite_paragraph_font_weight',array(
		'type' => 'select',
		'label' => __('Paragraph Font Weight','master-study-lite'),
		'section' => 'master_study_lite_typography',
		'choices' => array(
		   '100' => __('100','master-study-lite'),
         '200' => __('200','master-study-lite'),
         '300' => __('300','master-study-lite'),
         '400' => __('400','master-study-lite'),
         '500' => __('500','master-study-lite'),
         '600' => __('600','master-study-lite'),
         '700' => __('700','master-study-lite'),
         '800' => __('800','master-study-lite'),
         '900' => __('900','master-study-lite'),
		),
	) );		

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting('master_study_lite_atag_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_atag_color', array(
		'label'    => __('"a" Tag Color', 'master-study-lite'),
		'section'  => 'master_study_lite_typography',
		'settings' => 'master_study_lite_atag_color',
	)));

	//This is "a" Tag FontFamily picker setting
	$wp_customize->add_setting('master_study_lite_atag_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'master_study_lite_sanitize_choices',
	));
	$wp_customize->add_control(	'master_study_lite_atag_font_family', array(
		'section' => 'master_study_lite_typography',
		'label'   => __('"a" Tag Fonts', 'master-study-lite'),
		'type'    => 'select',
		'choices' => $master_study_lite_font_array,
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting('master_study_lite_li_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_li_color', array(
		'label'    => __('"li" Tag Color', 'master-study-lite'),
		'section'  => 'master_study_lite_typography',
		'settings' => 'master_study_lite_li_color',
	)));

	//This is "li" Tag FontFamily picker setting
	$wp_customize->add_setting('master_study_lite_li_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'master_study_lite_sanitize_choices',
	));
	$wp_customize->add_control(	'master_study_lite_li_font_family', array(
		'section' => 'master_study_lite_typography',
		'label'   => __('"li" Tag Fonts', 'master-study-lite'),
		'type'    => 'select',
		'choices' => $master_study_lite_font_array,
	));

	// This is H1 Color picker setting
	$wp_customize->add_setting('master_study_lite_h1_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_h1_color', array(
		'label'    => __('H1 Color', 'master-study-lite'),
		'section'  => 'master_study_lite_typography',
		'settings' => 'master_study_lite_h1_color',
	)));

	//This is H1 FontFamily picker setting
	$wp_customize->add_setting('master_study_lite_h1_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'master_study_lite_sanitize_choices',
	));
	$wp_customize->add_control('master_study_lite_h1_font_family', array(
		'section' => 'master_study_lite_typography',
		'label'   => __('H1 Fonts', 'master-study-lite'),
		'type'    => 'select',
		'choices' => $master_study_lite_font_array,
	));

	//This is H1 FontSize setting
	$wp_customize->add_setting('master_study_lite_h1_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('master_study_lite_h1_font_size', array(
		'label'   => __('H1 Font Size', 'master-study-lite'),
		'section' => 'master_study_lite_typography',
		'setting' => 'master_study_lite_h1_font_size',
		'type'    => 'text',
	));

	//This is H1 FontWeight setting	
	$wp_customize->add_setting('master_study_lite_h1_font_weight',array(
		'default' => '',
		'sanitize_callback' => 'master_study_lite_sanitize_choices'
 	));
 	$wp_customize->add_control('master_study_lite_h1_font_weight',array(
		'type' => 'select',
		'label' => __('H1 Font Weight','master-study-lite'),
		'section' => 'master_study_lite_typography',
		'choices' => array(
		   '100' => __('100','master-study-lite'),
         '200' => __('200','master-study-lite'),
         '300' => __('300','master-study-lite'),
         '400' => __('400','master-study-lite'),
         '500' => __('500','master-study-lite'),
         '600' => __('600','master-study-lite'),
         '700' => __('700','master-study-lite'),
         '800' => __('800','master-study-lite'),
         '900' => __('900','master-study-lite'),
		),
	) );		

	// This is H2 Color picker setting
	$wp_customize->add_setting('master_study_lite_h2_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_h2_color', array(
		'label'    => __('H2 Color', 'master-study-lite'),
		'section'  => 'master_study_lite_typography',
		'settings' => 'master_study_lite_h2_color',
	)));

	//This is H2 FontFamily picker setting
	$wp_customize->add_setting('master_study_lite_h2_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'master_study_lite_sanitize_choices',
	));
	$wp_customize->add_control(
	'master_study_lite_h2_font_family', array(
		'section' => 'master_study_lite_typography',
		'label'   => __('H2 Fonts', 'master-study-lite'),
		'type'    => 'select',
		'choices' => $master_study_lite_font_array,
	));

	//This is H2 FontSize setting
	$wp_customize->add_setting('master_study_lite_h2_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('master_study_lite_h2_font_size', array(
		'label'   => __('H2 Font Size', 'master-study-lite'),
		'section' => 'master_study_lite_typography',
		'setting' => 'master_study_lite_h2_font_size',
		'type'    => 'text',
	));

	//This is H2 FontWeight setting	
	$wp_customize->add_setting('master_study_lite_h2_font_weight',array(
		'default' => '',
		'sanitize_callback' => 'master_study_lite_sanitize_choices'
 	));
 	$wp_customize->add_control('master_study_lite_h2_font_weight',array(
		'type' => 'select',
		'label' => __('H2 Font Weight','master-study-lite'),
		'section' => 'master_study_lite_typography',
		'choices' => array(
		   '100' => __('100','master-study-lite'),
         '200' => __('200','master-study-lite'),
         '300' => __('300','master-study-lite'),
         '400' => __('400','master-study-lite'),
         '500' => __('500','master-study-lite'),
         '600' => __('600','master-study-lite'),
         '700' => __('700','master-study-lite'),
         '800' => __('800','master-study-lite'),
         '900' => __('900','master-study-lite'),
		),
	) );

	// This is H3 Color picker setting
	$wp_customize->add_setting('master_study_lite_h3_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_h3_color', array(
		'label'    => __('H3 Color', 'master-study-lite'),
		'section'  => 'master_study_lite_typography',
		'settings' => 'master_study_lite_h3_color',
	)));

	//This is H3 FontFamily picker setting
	$wp_customize->add_setting('master_study_lite_h3_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'master_study_lite_sanitize_choices',
	));
	$wp_customize->add_control(
	'master_study_lite_h3_font_family', array(
		'section' => 'master_study_lite_typography',
		'label'   => __('H3 Fonts', 'master-study-lite'),
		'type'    => 'select',
		'choices' => $master_study_lite_font_array,
	));

	//This is H3 FontSize setting
	$wp_customize->add_setting('master_study_lite_h3_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('master_study_lite_h3_font_size', array(
		'label'   => __('H3 Font Size', 'master-study-lite'),
		'section' => 'master_study_lite_typography',
		'setting' => 'master_study_lite_h3_font_size',
		'type'    => 'text',
	));

	//This is H3 FontWeight setting	
	$wp_customize->add_setting('master_study_lite_h3_font_weight',array(
		'default' => '',
		'sanitize_callback' => 'master_study_lite_sanitize_choices'
 	));
 	$wp_customize->add_control('master_study_lite_h3_font_weight',array(
		'type' => 'select',
		'label' => __('H3 Font Weight','master-study-lite'),
		'section' => 'master_study_lite_typography',
		'choices' => array(
		   '100' => __('100','master-study-lite'),
         '200' => __('200','master-study-lite'),
         '300' => __('300','master-study-lite'),
         '400' => __('400','master-study-lite'),
         '500' => __('500','master-study-lite'),
         '600' => __('600','master-study-lite'),
         '700' => __('700','master-study-lite'),
         '800' => __('800','master-study-lite'),
         '900' => __('900','master-study-lite'),
		),
	) );	

	// This is H4 Color picker setting
	$wp_customize->add_setting('master_study_lite_h4_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_h4_color', array(
		'label'    => __('H4 Color', 'master-study-lite'),
		'section'  => 'master_study_lite_typography',
		'settings' => 'master_study_lite_h4_color',
	)));

	//This is H4 FontFamily picker setting
	$wp_customize->add_setting('master_study_lite_h4_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'master_study_lite_sanitize_choices',
	));
	$wp_customize->add_control('master_study_lite_h4_font_family', array(
		'section' => 'master_study_lite_typography',
		'label'   => __('H4 Fonts', 'master-study-lite'),
		'type'    => 'select',
		'choices' => $master_study_lite_font_array,
	));

	//This is H4 FontSize setting
	$wp_customize->add_setting('master_study_lite_h4_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('master_study_lite_h4_font_size', array(
		'label'   => __('H4 Font Size', 'master-study-lite'),
		'section' => 'master_study_lite_typography',
		'setting' => 'master_study_lite_h4_font_size',
		'type'    => 'text',
	));

	//This is H4 FontWeight setting	
	$wp_customize->add_setting('master_study_lite_h4_font_weight',array(
		'default' => '',
		'sanitize_callback' => 'master_study_lite_sanitize_choices'
 	));
 	$wp_customize->add_control('master_study_lite_h4_font_weight',array(
		'type' => 'select',
		'label' => __('H4 Font Weight','master-study-lite'),
		'section' => 'master_study_lite_typography',
		'choices' => array(
		   '100' => __('100','master-study-lite'),
         '200' => __('200','master-study-lite'),
         '300' => __('300','master-study-lite'),
         '400' => __('400','master-study-lite'),
         '500' => __('500','master-study-lite'),
         '600' => __('600','master-study-lite'),
         '700' => __('700','master-study-lite'),
         '800' => __('800','master-study-lite'),
         '900' => __('900','master-study-lite'),
		),
	) );	

	// This is H5 Color picker setting
	$wp_customize->add_setting('master_study_lite_h5_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_h5_color', array(
		'label'    => __('H5 Color', 'master-study-lite'),
		'section'  => 'master_study_lite_typography',
		'settings' => 'master_study_lite_h5_color',
	)));

	//This is H5 FontFamily picker setting
	$wp_customize->add_setting('master_study_lite_h5_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'master_study_lite_sanitize_choices',
	));
	$wp_customize->add_control('master_study_lite_h5_font_family', array(
		'section' => 'master_study_lite_typography',
		'label'   => __('H5 Fonts', 'master-study-lite'),
		'type'    => 'select',
		'choices' => $master_study_lite_font_array,
	));

	//This is H5 FontSize setting
	$wp_customize->add_setting('master_study_lite_h5_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('master_study_lite_h5_font_size', array(
		'label'   => __('H5 Font Size', 'master-study-lite'),
		'section' => 'master_study_lite_typography',
		'setting' => 'master_study_lite_h5_font_size',
		'type'    => 'text',
	));

	//This is H5 FontWeight setting	
	$wp_customize->add_setting('master_study_lite_h5_font_weight',array(
		'default' => '',
		'sanitize_callback' => 'master_study_lite_sanitize_choices'
 	));
 	$wp_customize->add_control('master_study_lite_h5_font_weight',array(
		'type' => 'select',
		'label' => __('H5 Font Weight','master-study-lite'),
		'section' => 'master_study_lite_typography',
		'choices' => array(
		   '100' => __('100','master-study-lite'),
         '200' => __('200','master-study-lite'),
         '300' => __('300','master-study-lite'),
         '400' => __('400','master-study-lite'),
         '500' => __('500','master-study-lite'),
         '600' => __('600','master-study-lite'),
         '700' => __('700','master-study-lite'),
         '800' => __('800','master-study-lite'),
         '900' => __('900','master-study-lite'),
		),
	) );	

	// This is H6 Color picker setting
	$wp_customize->add_setting('master_study_lite_h6_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_h6_color', array(
		'label'    => __('H6 Color', 'master-study-lite'),
		'section'  => 'master_study_lite_typography',
		'settings' => 'master_study_lite_h6_color',
	)));

	//This is H6 FontFamily picker setting
	$wp_customize->add_setting('master_study_lite_h6_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'master_study_lite_sanitize_choices',
	));
	$wp_customize->add_control('master_study_lite_h6_font_family', array(
		'section' => 'master_study_lite_typography',
		'label'   => __('H6 Fonts', 'master-study-lite'),
		'type'    => 'select',
		'choices' => $master_study_lite_font_array,
	));

	//This is H6 FontSize setting
	$wp_customize->add_setting('master_study_lite_h6_font_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('master_study_lite_h6_font_size', array(
		'label'   => __('H6 Font Size', 'master-study-lite'),
		'section' => 'master_study_lite_typography',
		'setting' => 'master_study_lite_h6_font_size',
		'type'    => 'text',
	));

	//This is H6 FontWeight setting	
	$wp_customize->add_setting('master_study_lite_h6_font_weight',array(
		'default' => '',
		'sanitize_callback' => 'master_study_lite_sanitize_choices'
 	));
 	$wp_customize->add_control('master_study_lite_h6_font_weight',array(
		'type' => 'select',
		'label' => __('H6 Font Weight','master-study-lite'),
		'section' => 'master_study_lite_typography',
		'choices' => array(
		   '100' => __('100','master-study-lite'),
         '200' => __('200','master-study-lite'),
         '300' => __('300','master-study-lite'),
         '400' => __('400','master-study-lite'),
         '500' => __('500','master-study-lite'),
         '600' => __('600','master-study-lite'),
         '700' => __('700','master-study-lite'),
         '800' => __('800','master-study-lite'),
         '900' => __('900','master-study-lite'),
		),
	) );	

 	//Header Section
	$wp_customize->add_section('master_study_lite_header_section',array(
		'title'	=> __('Header','master-study-lite'),
		'description'	=> __('Add Header here','master-study-lite'),
		'priority'	=> null,
		'panel' => 'master_study_lite_panel_id',
	));

	$wp_customize->add_setting('master_study_lite_header_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('master_study_lite_header_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','master-study-lite'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','master-study-lite') ."</li><li>". esc_html__('And so on...','master-study-lite') ."</li></ul><a target='_blank' href='". esc_url(MASTER_STUDY_LITE_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','master-study-lite') ."</a>",
   		 'section'=> 'master_study_lite_header_section'
 	));
	
	$wp_customize->add_setting('master_study_lite_topbar_hide',array(
		'default' => false,
		'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
	));
	$wp_customize->add_control('master_study_lite_topbar_hide',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Topbar','master-study-lite'),
		'section' => 'master_study_lite_header_section',
	));	

	$wp_customize->add_setting('master_study_lite_top_sidebar_phone_no_icon',array(
		'default'	=> 'fas fa-phone',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
        $wp_customize,'master_study_lite_top_sidebar_phone_no_icon',array(
		'label'	=> __('Add Phone Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_header_section',
		'setting'	=> 'master_study_lite_top_sidebar_phone_no_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('master_study_lite_top_sidebar_phone_number',array(
		'default'=> '',
		'sanitize_callback'	=> 'master_study_lite_sanitize_phone_number'
	));
	$wp_customize->add_control('master_study_lite_top_sidebar_phone_number',array(
		'label'	=> __('Add Phone Number','master-study-lite'),
		'input_attrs' => array(
      'placeholder' => __( '123-123456789', 'master-study-lite' ),
    ),
		'section'=> 'master_study_lite_header_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('master_study_lite_top_sidebar_email_address_icon',array(
		'default'	=> 'fa-solid fa-envelope-open-text',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
        $wp_customize,'master_study_lite_top_sidebar_email_address_icon',array(
		'label'	=> __('Add Email Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_header_section',
		'setting'	=> 'master_study_lite_top_sidebar_email_address_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('master_study_lite_top_sidebar_email_address',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_email'
	));
	$wp_customize->add_control('master_study_lite_top_sidebar_email_address',array(
		'label'	=> __('Add Email Address','master-study-lite'),
		'input_attrs' => array(
      'placeholder' => __( 'xyz123@example.com', 'master-study-lite' ),
    ),
		'section'=> 'master_study_lite_header_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('master_study_lite_facebook_url',array(
		'default' => '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('master_study_lite_facebook_url',array(
		'type' => 'url',
		'label' => __('Add Facebook URL','master-study-lite'),
		'section' => 'master_study_lite_header_section',
	));

	$wp_customize->add_setting('master_study_lite_facebook_icon',array(
		'default'	=> 'fab fa-facebook-f',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
        $wp_customize,'master_study_lite_facebook_icon',array(
		'label'	=> __('Choose Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_header_section',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('master_study_lite_twitter_url',array(
		'default' => '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('master_study_lite_twitter_url',array(
		'type' => 'url',
		'label' => __('Add Twitter URL','master-study-lite'),
		'section' => 'master_study_lite_header_section',
	));

	$wp_customize->add_setting('master_study_lite_twitter_icon',array(
		'default'	=> 'fa-brands fa-x-twitter',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
        $wp_customize,'master_study_lite_twitter_icon',array(
		'label'	=> __('Choose Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_header_section',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('master_study_lite_instagram_url',array(
		'default' => '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('master_study_lite_instagram_url',array(
		'type' => 'url',
		'label' => __('Add Instagram URL','master-study-lite'),
		'section' => 'master_study_lite_header_section',
	));

	$wp_customize->add_setting('master_study_lite_instagram_icon',array(
		'default'	=> 'fab fa-instagram',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
        $wp_customize,'master_study_lite_instagram_icon',array(
		'label'	=> __('Choose Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_header_section',
		'type'		=> 'icon'
	)));

 	//Menu Section
	$wp_customize->add_section('master_study_lite_menu_section',array(
		'title'	=> __('Menu Settings','master-study-lite'),
		'priority'	=> null,
		'panel' => 'master_study_lite_panel_id',
	));

	$wp_customize->add_setting('master_study_lite_menu_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('master_study_lite_menu_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','master-study-lite'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','master-study-lite') ."</li><li>". esc_html__('And so on...','master-study-lite') ."</li></ul><a target='_blank' href='". esc_url(MASTER_STUDY_LITE_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','master-study-lite') ."</a>",
   		 'section'=> 'master_study_lite_menu_section'
 	));

	$wp_customize->add_setting('master_study_lite_menu_font_size_option',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Custom_Control( $wp_customize,'master_study_lite_menu_font_size_option',array(
		'label'	=> __('Menu Font Size','master-study-lite'),
		'section'=> 'master_study_lite_menu_section',
		'input_attrs' => array(
         'step' => 1,
			'min'  => 0,
			'max'  => 50,
     	),
	)));

	$wp_customize->add_setting('master_study_lite_menu_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Custom_Control( $wp_customize,'master_study_lite_menu_padding',array(
		'label'	=> __('Main Menu Padding','master-study-lite'),
		'section'=> 'master_study_lite_menu_section',
		'input_attrs' => array(
         'step' => 1,
			'min'  => 0,
			'max'  => 50,
      ),
	)));

	$wp_customize->add_setting('master_study_lite_font_weight_option_menu',array(
		'default' => '700',
		'sanitize_callback' => 'master_study_lite_sanitize_choices'
 	));
 	$wp_customize->add_control('master_study_lite_font_weight_option_menu',array(
		'type' => 'select',
		'label' => __('Menu Font Weight','master-study-lite'),
		'section' => 'master_study_lite_menu_section',
		'choices' => array(
		   '100' => __('100','master-study-lite'),
         '200' => __('200','master-study-lite'),
         '300' => __('300','master-study-lite'),
         '400' => __('400','master-study-lite'),
         '500' => __('500','master-study-lite'),
         '600' => __('600','master-study-lite'),
         '700' => __('700','master-study-lite'),
         '800' => __('800','master-study-lite'),
         '900' => __('900','master-study-lite'),
		),
	) );

	$wp_customize->add_setting('master_study_lite_menu_text_tranform',array(
		'default' => 'Uppercase',
		'sanitize_callback' => 'master_study_lite_sanitize_choices'
 	));
 	$wp_customize->add_control('master_study_lite_menu_text_tranform',array(
		'type' => 'select',
		'label' => __('Menu Text Transform','master-study-lite'),
		'section' => 'master_study_lite_menu_section',
		'choices' => array(
		   'Uppercase' => __('Uppercase','master-study-lite'),
		   'Lowercase' => __('Lowercase','master-study-lite'),
		   'Capitalize' => __('Capitalize','master-study-lite'),
		),
	) );

	$wp_customize->add_setting('master_study_lite_menus_item_style',array(
        'default' => '',
        'sanitize_callback' => 'master_study_lite_sanitize_choices'
	));
	$wp_customize->add_control('master_study_lite_menus_item_style',array(
        'type' => 'select',
		'label' => __('Menu Item Hover Style','master-study-lite'),
		'section' => 'master_study_lite_menu_section',
		'choices' => array(
         'None' => __('None','master-study-lite'),
         'Zoom In' => __('Zoom In','master-study-lite'),
      ),
	));

	$wp_customize->add_setting('master_study_lite_sub_menu_hover_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_sub_menu_hover_color', array(
		'label'    => __('Submenu Hover Color', 'master-study-lite'),
		'section'  => 'master_study_lite_menu_section',
		'settings' => 'master_study_lite_sub_menu_hover_color',
	)));

	$wp_customize->add_setting('master_study_lite_menu_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_menu_color', array(
		'label'    => __('Menu Color', 'master-study-lite'),
		'section'  => 'master_study_lite_menu_section',
		'settings' => 'master_study_lite_menu_color',
	)));

	$wp_customize->add_setting('master_study_lite_sub_menu_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_sub_menu_color', array(
		'label'    => __('Submenu Color', 'master-study-lite'),
		'section'  => 'master_study_lite_menu_section',
		'settings' => 'master_study_lite_sub_menu_color',
	)));

	$wp_customize->add_setting('master_study_lite_menu_hover_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_menu_hover_color', array(
		'label'    => __('Menu Hover Color', 'master-study-lite'),
		'section'  => 'master_study_lite_menu_section',
		'settings' => 'master_study_lite_menu_hover_color',
	)));

	//Slider Section
	$wp_customize->add_section( 'master_study_lite_slider_section' , array(
    	'title'      => __( 'Slider Section', 'master-study-lite' ),
		'priority'   => null,
		'panel' => 'master_study_lite_panel_id'
	) );

	$wp_customize->add_setting('master_study_lite_slider_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('master_study_lite_slider_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','master-study-lite'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','master-study-lite') ."</li><li>". esc_html__('And so on...','master-study-lite') ."</li></ul><a target='_blank' href='". esc_url(MASTER_STUDY_LITE_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','master-study-lite') ."</a>",
   		 'section'=> 'master_study_lite_slider_section'
 	));

	$wp_customize->add_setting('master_study_lite_slider_hide',array(
		'default' => false,
		'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
	));
	$wp_customize->add_control('master_study_lite_slider_hide',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Slider','master-study-lite'),
		'section' => 'master_study_lite_slider_section',
	));

	$wp_customize->add_setting('master_study_lite_slide_number',array(
		'default'	=> '',
		'sanitize_callback'	=> 'master_study_lite_sanitize_choices',
	));
	$wp_customize->add_control('master_study_lite_slide_number',array(
		'label'	=> __('Number of slides to show','master-study-lite'),
		'description' => __('Add number Of slide and refresh page','master-study-lite'),
		'section'	=> 'master_study_lite_slider_section',
		'type'		=> 'select',
		'choices' => array(
        	'1' => __('1','master-study-lite'),
         '2' => __('2','master-study-lite'),
         '3' => __('3','master-study-lite'),
        ),
	));

	$master_study_lite_count =  get_theme_mod('master_study_lite_slide_number');

	for($master_study_lite_i=1; $master_study_lite_i<=$master_study_lite_count; $master_study_lite_i++) {

		$wp_customize->add_setting('master_study_lite_slider_bg_image'.$master_study_lite_i,array(
			'default'	=> '',
			'sanitize_callback'	=> 'esc_url_raw',
		));
		$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'master_study_lite_slider_bg_image'.$master_study_lite_i,array(
	      'label' => __('Slider Background Image','master-study-lite'),
			'description' => __('Image Size (1920px × 700px).','master-study-lite'),
	      'section' => 'master_study_lite_slider_section'
		)));

	 	$wp_customize->add_setting('master_study_lite_slider_small_title'.$master_study_lite_i,array(
			'default'	=> '',
			'sanitize_callback'	=> 'sanitize_text_field'
		));
		$wp_customize->add_control('master_study_lite_slider_small_title'.$master_study_lite_i,array(
			'label'	=> __('Slider Small Title','master-study-lite'),
			'section'	=> 'master_study_lite_slider_section',
			'input_attrs' => array(
	        'placeholder' => __( 'Welcome To', 'master-study-lite' ),
	      ),
			'type'	=> 'text'
		));

	 	$wp_customize->add_setting('master_study_lite_slider_title'.$master_study_lite_i,array(
			'default'	=> '',
			'sanitize_callback'	=> 'sanitize_text_field'
		));
		$wp_customize->add_control('master_study_lite_slider_title'.$master_study_lite_i,array(
			'label'	=> __('Slider Title','master-study-lite'),
			'section'	=> 'master_study_lite_slider_section',
			'input_attrs' => array(
	        'placeholder' => __( 'Master Study Lite', 'master-study-lite' ),
	      ),
			'type'	=> 'text'
		));

	 	$wp_customize->add_setting('master_study_lite_slider_desc_text'.$master_study_lite_i,array(
			'default'	=> '',
			'sanitize_callback'	=> 'sanitize_text_field'
		));
		$wp_customize->add_control('master_study_lite_slider_desc_text'.$master_study_lite_i,array(
			'label'	=> __('Slider Content','master-study-lite'),
			'section'	=> 'master_study_lite_slider_section',
			'type'	=> 'text'
		));

		$wp_customize->add_setting('master_study_lite_slider_btn_text'.$master_study_lite_i,array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field'
	 	));
	 	$wp_customize->add_control('master_study_lite_slider_btn_text'.$master_study_lite_i,array(
			'type' => 'text',
			'label' => __('Add Button Text','master-study-lite'),
			'input_attrs' => array(
	        'placeholder' => __( 'Read More', 'master-study-lite' ),
	      ),
			'section' => 'master_study_lite_slider_section',
		) );

		$wp_customize->add_setting('master_study_lite_slider_btn_url'.$master_study_lite_i,array(
			'default' => '',
			'sanitize_callback' => 'esc_url_raw'
	 	));
	 	$wp_customize->add_control('master_study_lite_slider_btn_url'.$master_study_lite_i,array(
			'type' => 'text',
			'label' => __('Add Button URL','master-study-lite'),
			'input_attrs' => array(
	        'placeholder' => __( 'www.example-info.com', 'master-study-lite' ),
	      ),
			'section' => 'master_study_lite_slider_section',
		) );
	}

	$wp_customize->add_setting('master_study_lite_slider_opacity_color',array(
		'default'              => '0.6',
		'sanitize_callback' => 'master_study_lite_sanitize_choices'
	  ));
	  $wp_customize->add_control( 'master_study_lite_slider_opacity_color', array(
	  	  'type'        => 'select',
		  'label'       => __( 'Slider Image Opacity','master-study-lite' ),
		  'section'     => 'master_study_lite_slider_section',
		  'choices' => array(
			'0' =>  esc_attr__('0','master-study-lite'),
			'0.1' =>  esc_attr__('0.1','master-study-lite'),
			'0.2' =>  esc_attr__('0.2','master-study-lite'),
			'0.3' =>  esc_attr__('0.3','master-study-lite'),
			'0.4' =>  esc_attr__('0.4','master-study-lite'),
			'0.5' =>  esc_attr__('0.5','master-study-lite'),
			'0.6' =>  esc_attr__('0.6','master-study-lite'),
			'0.7' =>  esc_attr__('0.7','master-study-lite'),
			'0.8' =>  esc_attr__('0.8','master-study-lite'),
			'0.9' =>  esc_attr__('0.9','master-study-lite')
		  ),
	));

	//Faculties Section
  	$wp_customize->add_section('master_study_lite_faculties_section',array(
		'title' => __('Faculties Section','master-study-lite'),
		'description' => '',
		'priority'  => null,
		'panel' => 'master_study_lite_panel_id',
	));

	$wp_customize->add_setting('master_study_lite_faculties_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('master_study_lite_faculties_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','master-study-lite'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','master-study-lite') ."</li><li>". esc_html__('And so on...','master-study-lite') ."</li></ul><a target='_blank' href='". esc_url(MASTER_STUDY_LITE_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','master-study-lite') ."</a>",
   		 'section'=> 'master_study_lite_faculties_section'
 	));

	$wp_customize->add_setting('master_study_lite_section_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('master_study_lite_section_title',array(
		'label'	=> __('Add Section Title','master-study-lite'),
		'input_attrs' => array(
         'placeholder' => __( 'OUR FACULTIES', 'master-study-lite' ),
      ),
		'section'=> 'master_study_lite_faculties_section',
		'type'=> 'text'
	));	

	for($master_study_lite_j=1; $master_study_lite_j<=3; $master_study_lite_j++) {

		$wp_customize->add_setting('master_study_lite_faculties_image'.$master_study_lite_j,array(
			'default'	=> '',
			'sanitize_callback'	=> 'esc_url_raw',
		));
		$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'master_study_lite_faculties_image'.$master_study_lite_j,array(
	      'label' => __('Add Image','master-study-lite'),
			'description' => __('Image Size (480px × 300px) and use transparent image.','master-study-lite'),
	      'section' => 'master_study_lite_faculties_section'
		)));	

		$wp_customize->add_setting('master_study_lite_member_name'.$master_study_lite_j,array(
			'default'=> '',
			'sanitize_callback'	=> 'sanitize_text_field'
		));
		$wp_customize->add_control('master_study_lite_member_name'.$master_study_lite_j,array(
			'label'	=> __('Add Name','master-study-lite'),
			'input_attrs' => array(
	         'placeholder' => __( 'Anna Beyone', 'master-study-lite' ),
	      ),
			'section'=> 'master_study_lite_faculties_section',
			'type'=> 'text'
		));

		$wp_customize->add_setting('master_study_lite_member_name_url'.$master_study_lite_j,array(
			'default' => '',
			'sanitize_callback'	=> 'esc_url_raw'
		));
		$wp_customize->add_control('master_study_lite_member_name_url'.$master_study_lite_j,array(
			'type' => 'url',
			'label' => __('Add URL','master-study-lite'),
			'section' => 'master_study_lite_faculties_section',
		));

		$wp_customize->add_setting('master_study_lite_add_designation'.$master_study_lite_j,array(
			'default'=> '',
			'sanitize_callback'	=> 'sanitize_text_field'
		));
		$wp_customize->add_control('master_study_lite_add_designation'.$master_study_lite_j,array(
			'label'	=> __('Add Designation','master-study-lite'),
			'input_attrs' => array(
	         'placeholder' => __( 'DIRECTOR', 'master-study-lite' ),
	      ),
			'section'=> 'master_study_lite_faculties_section',
			'type'=> 'text'
		));

		$wp_customize->add_setting('master_study_lite_add_description'.$master_study_lite_j,array(
			'default'=> '',
			'sanitize_callback'	=> 'sanitize_text_field'
		));
		$wp_customize->add_control('master_study_lite_add_description'.$master_study_lite_j,array(
			'label'	=> __('Add Description','master-study-lite'),
			'section'=> 'master_study_lite_faculties_section',
			'type'=> 'text'
		));
	}

	//layout setting
	$wp_customize->add_section( 'master_study_lite_option', array(
    	'title'      => __( 'Layout Settings', 'master-study-lite' ),
    	'panel'    => 'master_study_lite_panel_id',
	) );

	$wp_customize->add_setting('master_study_lite_layout_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('master_study_lite_layout_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','master-study-lite'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','master-study-lite') ."</li><li>". esc_html__('And so on...','master-study-lite') ."</li></ul><a target='_blank' href='". esc_url(MASTER_STUDY_LITE_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','master-study-lite') ."</a>",
   		 'section'=> 'master_study_lite_option'
 	));

	$wp_customize->add_setting( 'master_study_lite_single_page_breadcrumb',array(
	   'default' => false,
    	'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
  	) );
	$wp_customize->add_control('master_study_lite_single_page_breadcrumb',array(
		'type' => 'checkbox',
		'label' => __( 'Show / Hide Single Page Breadcrumb','master-study-lite' ),
		'section' => 'master_study_lite_option'
	));

	$wp_customize->add_setting('master_study_lite_preloader',array(
       'default' => false,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
   ));
    $wp_customize->add_control('master_study_lite_preloader',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Preloader','master-study-lite'),
       'section' => 'master_study_lite_option'
   ));

   $wp_customize->add_setting('master_study_lite_preloader_type',array(
     	'default' => 'First Preloader Type',
     	'sanitize_callback' => 'master_study_lite_sanitize_choices'
	));
	$wp_customize->add_control('master_study_lite_preloader_type',array(
      'type' => 'radio',
      'label' => __('Preloader Types','master-study-lite'),
      'section' => 'master_study_lite_option',
      'choices' => array(
         'First Preloader Type' => __('First Preloader Type','master-study-lite'),
         'Second Preloader Type' => __('Second Preloader Type','master-study-lite'),
      ),
	) );

	$wp_customize->add_setting('master_study_lite_preloader_bg_color_option', array(
		'default'           => 'var(--first-theme-color)',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_preloader_bg_color_option', array(
		'label'    => __('Preloader Background Color', 'master-study-lite'),
		'section'  => 'master_study_lite_option',
	)));

	$wp_customize->add_setting('master_study_lite_preloader_icon_color_option', array(
		'default'           => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_preloader_icon_color_option', array(
		'label'    => __('Preloader Icon Color', 'master-study-lite'),
		'section'  => 'master_study_lite_option',
	)));

	$wp_customize->add_setting('master_study_lite_preloader_bg_img',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'master_study_lite_preloader_bg_img',array(
        'label' => __('Preloader Background Image','master-study-lite'),
        'section' => 'master_study_lite_option'
	)));	

	$wp_customize->add_setting('master_study_lite_width_layout_options',array(
		'default' => 'Default',
		'sanitize_callback' => 'master_study_lite_sanitize_choices'
	));
	$wp_customize->add_control('master_study_lite_width_layout_options',array(
		'type' => 'radio',
		'label' => __('Container Box','master-study-lite'),
		'description' => __('Here you can change the Width layout. ','master-study-lite'),
		'section' => 'master_study_lite_option',
		'choices' => array(
		   'Default' => __('Default','master-study-lite'),
		   'Container Layout' => __('Container Layout','master-study-lite'),
		   'Box Layout' => __('Box Layout','master-study-lite'),
		),
	) );

	// Add page sidebar
	$wp_customize->add_setting('master_study_lite_page_sidebar',array(
        'default' => 'One Column',
        'sanitize_callback' => 'master_study_lite_sanitize_choices'
	) );
	$wp_customize->add_control('master_study_lite_page_sidebar', array(
        'type' => 'select',
        'label' => __('Page Sidebar Layout','master-study-lite'),
        'section' => 'master_study_lite_option',
        'choices' => array(
            'One Column' => __('One Column','master-study-lite'),
            'Left Sidebar' => __('Left Sidebar','master-study-lite'),
            'Right Sidebar' => __('Right Sidebar','master-study-lite')
        ),
	)   );

	// Add Settings and Controls for Layout
	$wp_customize->add_setting('master_study_lite_layout_options',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'master_study_lite_sanitize_choices'
	) );
	$wp_customize->add_control('master_study_lite_layout_options', array(
        'type' => 'select',
        'label' => __('Post Sidebar Layout','master-study-lite'),
        'section' => 'master_study_lite_option',
        'choices' => array(
            'One Column' => __('One Column','master-study-lite'),
            'Three Columns' => __('Three Columns','master-study-lite'),
            'Four Columns' => __('Four Columns','master-study-lite'),
            'Grid Layout' => __('Grid Layout','master-study-lite'),
            'Left Sidebar' => __('Left Sidebar','master-study-lite'),
            'Right Sidebar' => __('Right Sidebar','master-study-lite')
        ),
	)   );

	$wp_customize->add_setting('master_study_lite_sidebar_size',array(
        'default' => 'Sidebar 1/3',
        'sanitize_callback' => 'master_study_lite_sanitize_choices'
	));
	$wp_customize->add_control('master_study_lite_sidebar_size',array(
        'type' => 'radio',
        'label' => __('Sidebar Size Option','master-study-lite'),
        'section' => 'master_study_lite_option',
        'choices' => array(
            'Sidebar 1/3' => __('Sidebar 1/3','master-study-lite'),
            'Sidebar 1/4' => __('Sidebar 1/4','master-study-lite'),
        ),
	) );

	//Global Color
	$wp_customize->add_section('master_study_lite_global_color', array(
		'title'    => __('Theme Color Option', 'master-study-lite'),
		'panel'    => 'master_study_lite_panel_id',
	));

	$wp_customize->add_setting('master_study_lite_global_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('master_study_lite_global_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','master-study-lite'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','master-study-lite') ."</li><li>". esc_html__('And so on...','master-study-lite') ."</li></ul><a target='_blank' href='". esc_url(MASTER_STUDY_LITE_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','master-study-lite') ."</a>",
   		 'section'=> 'master_study_lite_global_color'
 	));

	$wp_customize->add_setting('master_study_lite_first_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_first_color', array(
		'label'    => __('Highlight Color', 'master-study-lite'),
		'section'  => 'master_study_lite_global_color',
		'settings' => 'master_study_lite_first_color',
	)));

	$wp_customize->add_setting('master_study_lite_second_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_second_color', array(
		'label'    => __('Highlight Color', 'master-study-lite'),
		'section'  => 'master_study_lite_global_color',
		'settings' => 'master_study_lite_second_color',
	)));

	//Blog Post Settings
	$wp_customize->add_section('master_study_lite_post_settings', array(
		'title'    => __('Post General Settings', 'master-study-lite'),
		'panel'    => 'master_study_lite_panel_id',
	));

	$wp_customize->add_setting('master_study_lite_post_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('master_study_lite_post_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','master-study-lite'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','master-study-lite') ."</li><li>". esc_html__('And so on...','master-study-lite') ."</li></ul><a target='_blank' href='". esc_url(MASTER_STUDY_LITE_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','master-study-lite') ."</a>",
   		 'section'=> 'master_study_lite_post_settings'
 	));

	$wp_customize->add_setting('master_study_lite_post_layouts',array(
		'default' => 'Layout 2',
		'sanitize_callback' => 'master_study_lite_sanitize_choices'
	));
	$wp_customize->add_control('master_study_lite_post_layouts', array(
		'type' => 'select',
		'label' => __('Post Layouts','master-study-lite'),
		'description' => __('Here you can change the 3 different layouts of post','master-study-lite'),
		'section' => 'master_study_lite_post_settings',
		'choices' => array(
		   'Layout 1' => __('Layouts 1','master-study-lite'),
		   'Layout 2' => __('Layouts 2','master-study-lite'),
		   'Layout 3' => __('Layouts 3','master-study-lite'),
	)));

   $wp_customize->add_setting('master_study_lite_post_block_option',array(
        'default' => 'By Block',
        'sanitize_callback' => 'master_study_lite_sanitize_choices'
	));
	$wp_customize->add_control('master_study_lite_post_block_option',array(
        'type' => 'select',
        'label' => __('Blog Post Shown','master-study-lite'),
        'section' => 'master_study_lite_post_settings',
        'choices' => array(
            'By Block' => __('By Block','master-study-lite'),
            'By Without Block' => __('By Without Block','master-study-lite'),
        ),
	) );

	$wp_customize->add_setting('master_study_lite_metafields_date',array(
		'default' => true,
		'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
	));
	$wp_customize->add_control('master_study_lite_metafields_date',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Date','master-study-lite'),
		'section' => 'master_study_lite_post_settings'
	));

	$wp_customize->add_setting('master_study_lite_post_date_icon',array(
		'default'	=> 'far fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
        $wp_customize,'master_study_lite_post_date_icon',array(
		'label'	=> __('Post Date Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_post_settings',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting('master_study_lite_metafields_author',array(
       'default' => true,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
    ));
    $wp_customize->add_control('master_study_lite_metafields_author',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Author','master-study-lite'),
       'section' => 'master_study_lite_post_settings'
    ));

    $wp_customize->add_setting('master_study_lite_post_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
        $wp_customize,'master_study_lite_post_author_icon',array(
		'label'	=> __('Post Author Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_post_settings',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting('master_study_lite_metafields_comment',array(
       'default' => true,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
    ));
    $wp_customize->add_control('master_study_lite_metafields_comment',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Comments','master-study-lite'),
       'section' => 'master_study_lite_post_settings'
    ));

    $wp_customize->add_setting('master_study_lite_post_comment_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
        $wp_customize,'master_study_lite_post_comment_icon',array(
		'label'	=> __('Post Comment Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_post_settings',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting('master_study_lite_metafields_time',array(
       'default' => true,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
    ));
    $wp_customize->add_control('master_study_lite_metafields_time',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Time','master-study-lite'),
       'section' => 'master_study_lite_post_settings'
    ));

    $wp_customize->add_setting('master_study_lite_post_time_icon',array(
		'default'	=> 'fas fa-clock',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
        $wp_customize,'master_study_lite_post_time_icon',array(
		'label'	=> __('Post Time Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_post_settings',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('master_study_lite_post_featured_image',array(
       'default' => 'Image',
       'sanitize_callback'	=> 'master_study_lite_sanitize_choices'
    ));
    $wp_customize->add_control('master_study_lite_post_featured_image',array(
       'type' => 'select',
       'label'	=> __('Post Image Options','master-study-lite'),
       'choices' => array(
            'Image' => __('Image','master-study-lite'),
            'Color' => __('Color','master-study-lite'),
            'None' => __('None','master-study-lite'),
        ),
      	'section'	=> 'master_study_lite_post_settings',
    ));

    $wp_customize->add_setting('master_study_lite_post_featured_color', array(
		'default'           => 'var(--first-theme-color)',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_post_featured_color', array(
		'label'    => __('Post Color', 'master-study-lite'),
		'section'  => 'master_study_lite_post_settings',
		'settings' => 'master_study_lite_post_featured_color',
		'active_callback' => 'master_study_lite_post_color_enabled'
	)));

	$wp_customize->add_setting( 'master_study_lite_custom_post_color_width',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_custom_post_color_width',	array(
		'label' => esc_html__( 'Color Post Custom Width','master-study-lite' ),
		'section' => 'master_study_lite_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 500,
			'step' => 1,
		),
		'active_callback' => 'master_study_lite_show_post_color'
	)));

	$wp_customize->add_setting( 'master_study_lite_custom_post_color_height',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_custom_post_color_height',array(
		'label' => esc_html__( 'Color Post Custom Height','master-study-lite' ),
		'section' => 'master_study_lite_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 350,
			'step' => 1,
		),
		'active_callback' => 'master_study_lite_show_post_color'
	)));

	$wp_customize->add_setting('master_study_lite_post_featured_image_dimention',array(
       'default' => 'Default',
       'sanitize_callback'	=> 'master_study_lite_sanitize_choices'
    ));
    $wp_customize->add_control('master_study_lite_post_featured_image_dimention',array(
       'type' => 'select',
       'label'	=> __('Post Featured Image Dimention','master-study-lite'),
       'choices' => array(
            'Default' => __('Default','master-study-lite'),
            'Custom' => __('Custom','master-study-lite'),
        ),
      	'section'	=> 'master_study_lite_post_settings',
      	'active_callback' => 'master_study_lite_enable_post_featured_image'
    ));

    $wp_customize->add_setting( 'master_study_lite_post_featured_image_custom_width',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_post_featured_image_custom_width',	array(
		'label' => esc_html__( 'Post Featured Image Custom Width','master-study-lite' ),
		'section' => 'master_study_lite_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 500,
			'step' => 1,
		),
		'active_callback' => 'master_study_lite_enable_post_image_custom_dimention'
	)));

	$wp_customize->add_setting( 'master_study_lite_post_featured_image_custom_height',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_post_featured_image_custom_height',	array(
		'label' => esc_html__( 'Post Featured Image Custom Height','master-study-lite' ),
		'section' => 'master_study_lite_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 350,
			'step' => 1,
		),
		'active_callback' => 'master_study_lite_enable_post_image_custom_dimention'
	)));

	$wp_customize->add_setting( 'master_study_lite_image_border_radius', array(
		'default'=> 0,
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control(new Master_Study_Lite_Custom_Control( $wp_customize,  'master_study_lite_image_border_radius', array(
		'label'       => esc_html__( 'Featured Image Border Radius','master-study-lite' ),
		'section'     => 'master_study_lite_post_settings',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	)) );

	$wp_customize->add_setting( 'master_study_lite_image_box_shadow',array(
		'default' => 0,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'absint',
		'sanitize_js_callback' => 'absint',
	));
	$wp_customize->add_control(new Master_Study_Lite_Custom_Control( $wp_customize,  'master_study_lite_image_box_shadow',array(
		'label' => esc_html__( 'Featured Image Shadow','master-study-lite' ),
		'section' => 'master_study_lite_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
		'type'		=> 'range'
	)));

	$wp_customize->add_setting('master_study_lite_show_first_caps',array(
      'default' => false,
      'sanitize_callback' => 'master_study_lite_sanitize_checkbox',
    ));
	$wp_customize->add_control( 'master_study_lite_show_first_caps',array(
		'label' => esc_html__('First Cap (First Capital Letter)', 'master-study-lite'),
		'type' => 'checkbox',
		'section' => 'master_study_lite_post_settings',
	));

    //Post excerpt
	$wp_customize->add_setting( 'master_study_lite_post_excerpt_number', array(
		'default'              => 30,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'absint',
		'sanitize_js_callback' => 'absint',
	) );
	$wp_customize->add_control( 'master_study_lite_post_excerpt_number', array(
		'label'       => esc_html__( 'Blog Post Content Limit','master-study-lite' ),
		'section'     => 'master_study_lite_post_settings',
		'type'        => 'number',
		'settings'    => 'master_study_lite_post_excerpt_number',
		'input_attrs' => array(
			'step'             => 2,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('master_study_lite_content_settings',array(
        'default' =>'Excerpt',
        'sanitize_callback' => 'master_study_lite_sanitize_choices'
	));
	$wp_customize->add_control('master_study_lite_content_settings',array(
        'type' => 'radio',
        'label' => __('Content Settings','master-study-lite'),
        'section' => 'master_study_lite_post_settings',
        'choices' => array(
            'Excerpt' => __('Excerpt','master-study-lite'),
            'Content' => __('Content','master-study-lite'),
        ),
	) );

	$wp_customize->add_setting( 'master_study_lite_post_discription_suffix', array(
		'default'   => __('[...]','master-study-lite'),
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'master_study_lite_post_discription_suffix', array(
		'label'       => esc_html__( 'Post Excerpt Suffix','master-study-lite' ),
		'section'     => 'master_study_lite_post_settings',
		'type'        => 'text',
		'settings'    => 'master_study_lite_post_discription_suffix',
	) );

	$wp_customize->add_setting( 'master_study_lite_blog_post_meta_seperator', array(
		'default'   => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'master_study_lite_blog_post_meta_seperator', array(
		'label'       => esc_html__( 'Meta Box Separator','master-study-lite' ),
		'section'     => 'master_study_lite_post_settings',
		'description' => __('Here you can add the seperator for meta box. e.g. "|",  ",", "/", etc. ','master-study-lite'),
		'type'        => 'text',
		'settings'    => 'master_study_lite_blog_post_meta_seperator',
	) );

	$wp_customize->add_setting('master_study_lite_enable_post_pagination',array(
       'default' => true,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
   ));
   $wp_customize->add_control('master_study_lite_enable_post_pagination',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Blog Page Pagination','master-study-lite'),
       'section' => 'master_study_lite_post_settings'
   ));

   $wp_customize->add_setting( 'master_study_lite_post_pagination_position', array(
        'default'			=>  'Bottom',
        'sanitize_callback'	=> 'master_study_lite_sanitize_choices'
   ));
   $wp_customize->add_control( 'master_study_lite_post_pagination_position', array(
        'section' => 'master_study_lite_post_settings',
        'type' => 'select',
        'label' => __( 'Post Pagination Position', 'master-study-lite' ),
        'choices'		=> array(
            'Top'  => __( 'Top', 'master-study-lite' ),
            'Bottom' => __( 'Bottom', 'master-study-lite' ),
            'Both Top & Bottom' => __( 'Both Top & Bottom', 'master-study-lite' ),
   )));

	$wp_customize->add_setting( 'master_study_lite_pagination_settings', array(
        'default'			=> 'Numeric Pagination',
        'sanitize_callback'	=> 'master_study_lite_sanitize_choices'
   ));
   $wp_customize->add_control( 'master_study_lite_pagination_settings', array(
        'section' => 'master_study_lite_post_settings',
        'type' => 'radio',
        'label' => __( 'Post Pagination', 'master-study-lite' ),
        'choices'		=> array(
            'Numeric Pagination'  => __( 'Numeric Pagination', 'master-study-lite' ),
            'next-prev' => __( 'Next / Previous', 'master-study-lite' ),
   )));

	//Button Settings
	$wp_customize->add_section('master_study_lite_button_settings', array(
		'title'    => __('Post Button Settings', 'master-study-lite'),
		'panel'    => 'master_study_lite_panel_id',
	));

	$wp_customize->add_setting('master_study_lite_post_btn_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('master_study_lite_post_btn_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','master-study-lite'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','master-study-lite') ."</li><li>". esc_html__('And so on...','master-study-lite') ."</li></ul><a target='_blank' href='". esc_url(MASTER_STUDY_LITE_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','master-study-lite') ."</a>",
   		 'section'=> 'master_study_lite_button_settings'
 	));

	$wp_customize->add_setting('master_study_lite_button_text',array(
		'default'=> __('Read More','master-study-lite'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('master_study_lite_button_text',array(
		'label'	=> __('Add Button Text','master-study-lite'),
		'section'=> 'master_study_lite_button_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('master_study_lite_btn_font_size_option',array(
		'default'=> 14,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Custom_Control( $wp_customize,'master_study_lite_btn_font_size_option',array(
		'label'	=> __('Button Font Size','master-study-lite'),
		'section'=> 'master_study_lite_button_settings',
		'input_attrs' => array(
         'step' => 1,
			'min'  => 0,
			'max'  => 50,
     	),
	)));

	$wp_customize->add_setting('master_study_lite_button_text_tranform',array(
		'default' => 'Capitalize',
		'sanitize_callback' => 'master_study_lite_sanitize_choices'
 	));
 	$wp_customize->add_control('master_study_lite_button_text_tranform',array(
		'type' => 'select',
		'label' => __('Button Text Transform','master-study-lite'),
		'section' => 'master_study_lite_button_settings',
		'choices' => array(
		   'Uppercase' => __('Uppercase','master-study-lite'),
		   'Lowercase' => __('Lowercase','master-study-lite'),
		   'Capitalize' => __('Capitalize','master-study-lite'),
		),
	) );

	$wp_customize->add_setting('master_study_lite_button_font_weight',array(
		'default' => '700',
		'sanitize_callback' => 'master_study_lite_sanitize_choices'
 	));
 	$wp_customize->add_control('master_study_lite_button_font_weight',array(
		'type' => 'select',
		'label' => __('Button Font Weight','master-study-lite'),
		'section' => 'master_study_lite_button_settings',
		'choices' => array(
			'100' => __('100','master-study-lite'),
			'200' => __('200','master-study-lite'),
			'300' => __('300','master-study-lite'),
			'400' => __('400','master-study-lite'),
			'500' => __('500','master-study-lite'),
			'600' => __('600','master-study-lite'),
			'700' => __('700','master-study-lite'),
			'800' => __('800','master-study-lite'),
			'900' => __('900','master-study-lite'),
		),
	) );

	$wp_customize->add_setting( 'master_study_lite_post_button_padding_top',array(
		'default' => '',
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control( new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_post_button_padding_top',	array(
		'label' => esc_html__( 'Button Top Bottom Padding (px)','master-study-lite' ),
		'section' => 'master_study_lite_button_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'master_study_lite_post_button_padding_right',array(
		'default' => '',
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control( new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_post_button_padding_right',	array(
		'label' => esc_html__( 'Button Right Left Padding (px)','master-study-lite' ),
		'section' => 'master_study_lite_button_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	// button letter spacing
	$wp_customize->add_setting( 'master_study_lite_button_letter_spacing',array(
		'default' => '',
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control( new  Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_button_letter_spacing', array(
		'label'  =>  esc_html__('Button Letter Spacing (px)','master-study-lite'),
		'section'  => 'master_study_lite_button_settings',
		'input_attrs' => array(
		   'min' => 0,
		   'max' => 50,
		   'step' => 1,
		)
 	)));		

	// Button Shape
	$wp_customize->add_setting('master_study_lite_btn_shape',array(
		'default'=> 'Square',
		'sanitize_callback'	=> 'master_study_lite_sanitize_choices',
	));
	$wp_customize->add_control('master_study_lite_btn_shape',array(
		'label'	=> __('Button Shape','master-study-lite'),
		'section'=> 'master_study_lite_button_settings',
		'type' => 'select',
		'choices' => array(
			'Square' => __('Square','master-study-lite'),
			'Round' => __('Round','master-study-lite'),
			'Pill' => __('Pill','master-study-lite'),
		),
	));	

   //Single Post Settings
	$wp_customize->add_section('master_study_lite_single_post_settings', array(
		'title'    => __('Single Post Settings', 'master-study-lite'),
		'panel'    => 'master_study_lite_panel_id',
	));

	$wp_customize->add_setting('master_study_lite_single_post_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('master_study_lite_single_post_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','master-study-lite'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','master-study-lite') ."</li><li>". esc_html__('And so on...','master-study-lite') ."</li></ul><a target='_blank' href='". esc_url(MASTER_STUDY_LITE_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','master-study-lite') ."</a>",
   		 'section'=> 'master_study_lite_single_post_settings'
 	));

	$wp_customize->add_setting('master_study_lite_single_post_bradcrumb',array(
		'default' => false,
		'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
	));
	$wp_customize->add_control('master_study_lite_single_post_bradcrumb',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Breadcrumb','master-study-lite'),
		'section' => 'master_study_lite_single_post_settings',
	));

	$wp_customize->add_setting('master_study_lite_single_post_date',array(
       'default' => true,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
   ));
   $wp_customize->add_control('master_study_lite_single_post_date',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Date','master-study-lite'),
       'section' => 'master_study_lite_single_post_settings'
   ));

   $wp_customize->add_setting('master_study_lite_single_post_date_icon',array(
		'default'	=> 'far fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
        $wp_customize,'master_study_lite_single_post_date_icon',array(
		'label'	=> __('Single Post Date Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_single_post_settings',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('master_study_lite_single_post_author',array(
       'default' => true,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
   ));
   $wp_customize->add_control('master_study_lite_single_post_author',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Author','master-study-lite'),
       'section' => 'master_study_lite_single_post_settings'
   ));

   $wp_customize->add_setting('master_study_lite_single_post_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
      $wp_customize,'master_study_lite_single_post_author_icon',array(
		'label'	=> __('Single Post Author Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_single_post_settings',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('master_study_lite_single_post_comment',array(
		'default' => true,
		'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
	));
	$wp_customize->add_control('master_study_lite_single_post_comment',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Comments','master-study-lite'),
		'section' => 'master_study_lite_single_post_settings'
	));

 	$wp_customize->add_setting('master_study_lite_single_post_comment_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer( $wp_customize, 'master_study_lite_single_post_comment_icon', array(
		'label'	=> __('Single Post Comment Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_single_post_settings',
		'type'		=> 'icon'
	)));

   $wp_customize->add_setting('master_study_lite_single_post_time',array(
       'default' => true,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
   ));
   $wp_customize->add_control('master_study_lite_single_post_time',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Time','master-study-lite'),
       'section' => 'master_study_lite_single_post_settings',
   ));

   $wp_customize->add_setting('master_study_lite_single_post_time_icon',array(
		'default'	=> 'fas fa-clock',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
        $wp_customize,'master_study_lite_single_post_time_icon',array(
		'label'	=> __('Single Post Time Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_single_post_settings',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('master_study_lite_post_comment_enable',array(
       'default' => true,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
   ));
   $wp_customize->add_control('master_study_lite_post_comment_enable',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable post comment','master-study-lite'),
       'section' => 'master_study_lite_single_post_settings',
   ));

	$wp_customize->add_setting('master_study_lite_single_post_featured_image',array(
       'default' => true,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
   ));
   $wp_customize->add_control('master_study_lite_single_post_featured_image',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Featured image','master-study-lite'),
       'section' => 'master_study_lite_single_post_settings',
   ));

	$wp_customize->add_setting('master_study_lite_show_hide_single_post_categories',array(
			'default' => true,
			'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
   ));
   $wp_customize->add_control('master_study_lite_show_hide_single_post_categories',array(
			'type' => 'checkbox',
			'label' => __('Single Post Categories','master-study-lite'),
			'section' => 'master_study_lite_single_post_settings'
   ));

	$wp_customize->add_setting('master_study_lite_single_post_tags',array(
      'default' => true,
      'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
   ));
   $wp_customize->add_control('master_study_lite_single_post_tags',array(
      'type' => 'checkbox',
      'label' => __('Enable / Disable Tags','master-study-lite'),
      'section' => 'master_study_lite_single_post_settings'
   ));

	$wp_customize->add_setting('master_study_lite_single_post_layout',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'master_study_lite_sanitize_choices'
	) );
	$wp_customize->add_control('master_study_lite_single_post_layout', array(
        'type' => 'select',
        'label' => __('Select different Single post sidebar layout','master-study-lite'),
        'section' => 'master_study_lite_single_post_settings',
        'choices' => array(
            'One Column' => __('One Column','master-study-lite'),
            'Left Sidebar' => __('Left Sidebar','master-study-lite'),
            'Right Sidebar' => __('Right Sidebar','master-study-lite')
        ),
	)   );

	$wp_customize->add_setting( 'master_study_lite_single_post_meta_seperator', array(
		'default'   => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'master_study_lite_single_post_meta_seperator', array(
		'label'       => esc_html__( 'Single Post Meta Box Seperator','master-study-lite' ),
		'section'     => 'master_study_lite_single_post_settings',
		'description' => __('Here you can add the seperator for meta box. e.g. "|",  ",", "/", etc. ','master-study-lite'),
		'type'        => 'text',
		'settings'    => 'master_study_lite_single_post_meta_seperator',
	) );

	$wp_customize->add_setting( 'master_study_lite_comment_form_width',array(
		'default' => 100,
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control( new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_comment_form_width',	array(
		'label' => esc_html__( 'Comment Form Width','master-study-lite' ),
		'section' => 'master_study_lite_single_post_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 100,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting('master_study_lite_title_comment_form',array(
       'default' => __('Leave a Reply','master-study-lite'),
       'sanitize_callback'	=> 'sanitize_text_field'
    ));
    $wp_customize->add_control('master_study_lite_title_comment_form',array(
       'type' => 'text',
       'label' => __('Comment Form Heading Text','master-study-lite'),
       'section' => 'master_study_lite_single_post_settings'
    ));

    $wp_customize->add_setting('master_study_lite_comment_form_button_content',array(
       'default' => __('Post Comment','master-study-lite'),
       'sanitize_callback'	=> 'sanitize_text_field'
    ));
    $wp_customize->add_control('master_study_lite_comment_form_button_content',array(
       'type' => 'text',
       'label' => __('Comment Form Button Text','master-study-lite'),
       'section' => 'master_study_lite_single_post_settings'
    ));

	$wp_customize->add_setting('master_study_lite_enable_single_post_pagination',array(
       'default' => true,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
   ));
   $wp_customize->add_control('master_study_lite_enable_single_post_pagination',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Single Post Pagination','master-study-lite'),
       'section' => 'master_study_lite_single_post_settings'
   ));

   $wp_customize->add_setting('master_study_lite_prev_text',array(
       'default' => 'Previous page',
       'sanitize_callback'	=> 'sanitize_text_field'
   ));
   $wp_customize->add_control('master_study_lite_prev_text',array(
       'type' => 'text',
       'label' => __('Previous Navigation Text','master-study-lite'),
       'section' => 'master_study_lite_single_post_settings'
   ));

   $wp_customize->add_setting('master_study_lite_next_text',array(
       'default' => 'Next page',
       'sanitize_callback'	=> 'sanitize_text_field'
   ));
   $wp_customize->add_control('master_study_lite_next_text',array(
       'type' => 'text',
       'label' => __('Next Navigation Text','master-study-lite'),
       'section' => 'master_study_lite_single_post_settings'
   ));

	//Grid Post Settings
	$wp_customize->add_section('master_study_lite_grid_settings', array(
		'title'    => __('Grid Post Settings', 'master-study-lite'),
		'panel'    => 'master_study_lite_panel_id',
	));

	$wp_customize->add_setting('master_study_lite_grid_post_date',array(
	'default' => true,
	'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
	));
	$wp_customize->add_control('master_study_lite_grid_post_date',array(
	'type' => 'checkbox',
	'label' => __('Enable / Disable Date','master-study-lite'),
	'section' => 'master_study_lite_grid_settings',
	));

	$wp_customize->add_setting('master_study_lite_grid_post_date_icon',array(
		'default'	=> 'far fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
		$wp_customize,'master_study_lite_grid_post_date_icon',array(
		'label'	=> __('Post Date Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_grid_settings',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('master_study_lite_grid_post_author',array(
	'default' => true,
	'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
	));
	$wp_customize->add_control('master_study_lite_grid_post_author',array(
	'type' => 'checkbox',
	'label' => __('Enable / Disable Author','master-study-lite'),
	'section' => 'master_study_lite_grid_settings',
	));

	$wp_customize->add_setting('master_study_lite_grid_post_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
		$wp_customize,'master_study_lite_grid_post_author_icon',array(
		'label'	=> __('Post Author Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_grid_settings',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('master_study_lite_grid_post_comment',array(
	'default' => true,
	'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
	));
	$wp_customize->add_control('master_study_lite_grid_post_comment',array(
	'type' => 'checkbox',
	'label' => __('Enable / Disable Comment','master-study-lite'),
	'section' => 'master_study_lite_grid_settings',
	));

	$wp_customize->add_setting('master_study_lite_grid_post_comment_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
		$wp_customize,'master_study_lite_grid_post_comment_icon',array(
		'label'	=> __('Post Comment Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_grid_settings',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('master_study_lite_grid_post_time',array(
	'default' => true,
	'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
	));
	$wp_customize->add_control('master_study_lite_grid_post_time',array(
	'type' => 'checkbox',
	'label' => __('Enable / Disable Time','master-study-lite'),
	'section' => 'master_study_lite_grid_settings',
	));

	$wp_customize->add_setting('master_study_lite_grid_post_time_icon',array(
		'default'	=> 'fas fa-clock',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
		$wp_customize,'master_study_lite_grid_post_time_icon',array(
		'label'	=> __('Post Time Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_grid_settings',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting( 'master_study_lite_grid_post_meta_seperator', array(
		'default'   => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control( 'master_study_lite_grid_post_meta_seperator', array(
		'label'       => esc_html__( 'Meta Box','master-study-lite' ),
		'section'     => 'master_study_lite_grid_settings',
		'description' => __('Here you can add the seperator for meta box. e.g. "|",  ",", "/", etc. ','master-study-lite'),
		'type'        => 'text',
		'settings'    => 'master_study_lite_grid_post_meta_seperator',
	));

	$wp_customize->add_setting( 'master_study_lite_grid_post_excerpt_number', array(
		'default'              => 30,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'absint',
		'sanitize_js_callback' => 'absint',
	));
	$wp_customize->add_control( 'master_study_lite_grid_post_excerpt_number', array(
		'label'       => esc_html__( 'Grid Post Content Limit','master-study-lite' ),
		'section'     => 'master_study_lite_grid_settings',
		'type'        => 'number',
		'settings'    => 'master_study_lite_grid_post_excerpt_number',
		'input_attrs' => array(
			'step'             => 2,
			'min'              => 0,
			'max'              => 50,
		),
	));

	$wp_customize->add_setting('master_study_lite_grid_columns',array(
		'default'           => '3',
		'sanitize_callback' => 'master_study_lite_sanitize_choices',
		'transport'         => 'refresh',
	));
	$wp_customize->add_control('master_study_lite_grid_columns',array(
		'type'        => 'radio',
		'label'       => __('Grid Post Columns', 'master-study-lite'),
		'section'     => 'master_study_lite_grid_settings',
		'choices' => array(
		   '3'     => __('Three', 'master-study-lite'),
		   '4'     => __('Four', 'master-study-lite')
		),
	));

	//Related Post Settings
	$wp_customize->add_section('master_study_lite_related_settings', array(
		'title'    => __('Related Post Settings', 'master-study-lite'),
		'panel'    => 'master_study_lite_panel_id',
	));

	$wp_customize->add_setting('master_study_lite_related_post_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('master_study_lite_related_post_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','master-study-lite'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','master-study-lite') ."</li><li>". esc_html__('And so on...','master-study-lite') ."</li></ul><a target='_blank' href='". esc_url(MASTER_STUDY_LITE_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','master-study-lite') ."</a>",
   		 'section'=> 'master_study_lite_related_settings'
 	));

	$wp_customize->add_setting( 'master_study_lite_related_enable_disable',array(
		'default' => true,
      	'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
    ) );
    $wp_customize->add_control('master_study_lite_related_enable_disable',array(
    	'type' => 'checkbox',
        'label' => __( 'Enable / Disable Related Post','master-study-lite' ),
        'section' => 'master_study_lite_related_settings'
    ));

	$wp_customize->add_setting('master_study_lite_related_metafields_date',array(
		'default' => true,
		'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
	));
	$wp_customize->add_control('master_study_lite_related_metafields_date',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Date','master-study-lite'),
		'section' => 'master_study_lite_related_settings'
	));

    $wp_customize->add_setting('master_study_lite_related_metafields_author',array(
       'default' => true,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
    ));
    $wp_customize->add_control('master_study_lite_related_metafields_author',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Author','master-study-lite'),
       'section' => 'master_study_lite_related_settings'
    ));

    $wp_customize->add_setting('master_study_lite_related_metafields_comment',array(
       'default' => true,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
    ));
    $wp_customize->add_control('master_study_lite_related_metafields_comment',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Comments','master-study-lite'),
       'section' => 'master_study_lite_related_settings'
    ));

    $wp_customize->add_setting('master_study_lite_related_metafields_time',array(
       'default' => true,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
    ));
    $wp_customize->add_control('master_study_lite_related_metafields_time',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Time','master-study-lite'),
       'section' => 'master_study_lite_related_settings'
    ));

    $wp_customize->add_setting('master_study_lite_related_title',array(
		'default'	=> 'Related Posts',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('master_study_lite_related_title',array(
		'label'	=> __('Add Section Title','master-study-lite'),
		'section'	=> 'master_study_lite_related_settings',
		'type'		=> 'text'
	));

	$wp_customize->add_setting( 'master_study_lite_related_posts_count_number', array(
		'default'              => 3,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'master_study_lite_related_posts_count_number', array(
		'label'       => esc_html__( 'Related Post Count','master-study-lite' ),
		'section'     => 'master_study_lite_related_settings',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 10,
		),
	) );

	$wp_customize->add_setting('master_study_lite_related_posts_taxanomies',array(
        'default' => 'categories',
        'sanitize_callback' => 'master_study_lite_sanitize_choices'
	));
	$wp_customize->add_control('master_study_lite_related_posts_taxanomies',array(
        'type' => 'radio',
        'label' => __('Post Taxonomies','master-study-lite'),
        'section' => 'master_study_lite_related_settings',
        'choices' => array(
            'categories' => __('Categories','master-study-lite'),
            'tags' => __('Tags','master-study-lite'),
        ),
	) );

	$wp_customize->add_setting( 'master_study_lite_related_post_excerpt_number',array(
		'default' => 15,
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));

	$wp_customize->add_control( new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_related_post_excerpt_number',	array(
		'label' => esc_html__( 'Content Limit','master-study-lite' ),
		'section' => 'master_study_lite_related_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting('master_study_lite_related_post_featured_image',array(
		'default' => true,
		'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
	));
	$wp_customize->add_control('master_study_lite_related_post_featured_image',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Featured image','master-study-lite'),
		'section' => 'master_study_lite_related_settings',
	)); 

	//Responsive Media Settings
	$wp_customize->add_section('master_study_lite_responsive_media',array(
		'title'	=> __('Responsive Media','master-study-lite'),
		'panel' => 'master_study_lite_panel_id',
	));

	$wp_customize->add_setting('master_study_lite_responsive_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('master_study_lite_responsive_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','master-study-lite'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','master-study-lite') ."</li><li>". esc_html__('And so on...','master-study-lite') ."</li></ul><a target='_blank' href='". esc_url(MASTER_STUDY_LITE_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','master-study-lite') ."</a>",
   		 'section'=> 'master_study_lite_responsive_media'
 	));

	$wp_customize->add_setting('master_study_lite_responsive_menu_open_icon',array(
		'default'	=> 'fas fa-bars',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
        $wp_customize,'master_study_lite_responsive_menu_open_icon',array(
		'label'	=> __('Responsive Open Menu Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_responsive_media',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('master_study_lite_responsive_menu_close_icon',array(
		'default'	=> 'fas fa-times',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
        $wp_customize,'master_study_lite_responsive_menu_close_icon',array(
		'label'	=> __('Responsive Close Menu Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_responsive_media',
		'type'		=> 'icon'
	)));

	// site toggle button color
	$wp_customize->add_setting('master_study_lite_toggle_button_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_toggle_button_color', array(
		'label'    => __('Toggle Button Color', 'master-study-lite'),
		'section'  => 'master_study_lite_responsive_media',
		'settings' => 'master_study_lite_toggle_button_color',
	)));

	$wp_customize->add_setting('master_study_lite_display_post_date',array(
       'default' => true,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
    ));
    $wp_customize->add_control('master_study_lite_display_post_date',array(
       'type' => 'checkbox',
       'label' => __('Display Post Date','master-study-lite'),
       'section' => 'master_study_lite_responsive_media'
    ));

    $wp_customize->add_setting('master_study_lite_display_post_author',array(
       'default' => true,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
    ));
    $wp_customize->add_control('master_study_lite_display_post_author',array(
       'type' => 'checkbox',
       'label' => __('Display Post Author','master-study-lite'),
       'section' => 'master_study_lite_responsive_media'
    ));

    $wp_customize->add_setting('master_study_lite_display_post_comment',array(
       'default' => true,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
    ));
    $wp_customize->add_control('master_study_lite_display_post_comment',array(
       'type' => 'checkbox',
       'label' => __('Display Post Comment','master-study-lite'),
       'section' => 'master_study_lite_responsive_media'
    ));

	$wp_customize->add_setting('master_study_lite_display_post_time',array(
		'default' => true,
		'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
	 ));
	 $wp_customize->add_control('master_study_lite_display_post_time',array(
		'type' => 'checkbox',
		'label' => __('Display Post Time','master-study-lite'),
		'section' => 'master_study_lite_responsive_media'
	 ));

	$wp_customize->add_setting('master_study_lite_display_sidebar',array(
       'default' => true,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
    ));
    $wp_customize->add_control('master_study_lite_display_sidebar',array(
       'type' => 'checkbox',
       'label' => __('Display Sidebar','master-study-lite'),
       'section' => 'master_study_lite_responsive_media'
    ));

    $wp_customize->add_setting('master_study_lite_display_preloader',array(
       'default' => false,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
    ));
    $wp_customize->add_control('master_study_lite_display_preloader',array(
       'type' => 'checkbox',
       'label' => __('Display Preloader','master-study-lite'),
       'section' => 'master_study_lite_responsive_media'
    ));

	$wp_customize->add_setting('master_study_lite_display_scroll',array(
		'default' => true,
		'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
	));
	$wp_customize->add_control('master_study_lite_display_scroll',array(
     	'type' => 'checkbox',
      	'label' => __('Display Scroll To Top','master-study-lite'),
      	'section' => 'master_study_lite_responsive_media',
	));

    //404 Page Setting
	$wp_customize->add_section('master_study_lite_page_not_found',array(
		'title'	=> __('404 Page Not Found / No Result','master-study-lite'),
		'panel' => 'master_study_lite_panel_id',
	));

	$wp_customize->add_setting('master_study_lite_page_not_found_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('master_study_lite_page_not_found_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','master-study-lite'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','master-study-lite') ."</li><li>". esc_html__('And so on...','master-study-lite') ."</li></ul><a target='_blank' href='". esc_url(MASTER_STUDY_LITE_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','master-study-lite') ."</a>",
   		 'section'=> 'master_study_lite_page_not_found'
 	));

	$wp_customize->add_setting('master_study_lite_page_not_found_heading',array(
		'default'=> __('404 Not Found','master-study-lite'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('master_study_lite_page_not_found_heading',array(
		'label'	=> __('404 Heading','master-study-lite'),
		'section'=> 'master_study_lite_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('master_study_lite_page_not_found_text',array(
		'default'=> __('Looks like you have taken a wrong turn. Dont worry it happens to the best of us.','master-study-lite'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('master_study_lite_page_not_found_text',array(
		'label'	=> __('404 Content','master-study-lite'),
		'section'=> 'master_study_lite_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('master_study_lite_page_not_found_button',array(
		'default'=>  __('Back to Home Page','master-study-lite'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('master_study_lite_page_not_found_button',array(
		'label'	=> __('404 Button','master-study-lite'),
		'section'=> 'master_study_lite_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('master_study_lite_no_search_result_heading',array(
		'default'=> __('Nothing Found','master-study-lite'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('master_study_lite_no_search_result_heading',array(
		'label'	=> __('No Search Results Heading','master-study-lite'),
		'description'=>__('The search page heading display when no results are found.','master-study-lite'),
		'section'=> 'master_study_lite_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('master_study_lite_no_search_result_text',array(
		'default'=> __('Sorry, but nothing matched your search terms. Please try again with some different keywords.','master-study-lite'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('master_study_lite_no_search_result_text',array(
		'label'	=> __('No Search Results Text','master-study-lite'),
		'description'=>__('The search page text display when no results are found.','master-study-lite'),
		'section'=> 'master_study_lite_page_not_found',
		'type'=> 'text'
	));

	//Woocommerce Section
	$wp_customize->add_section( 'master_study_lite_woocommerce_section' , array(
    	'title'      => __( 'Woocommerce Settings', 'master-study-lite' ),
    	'description'=>__('The below settings are apply on woocommerce pages.','master-study-lite'),
		'priority'   => null,
		'panel' => 'master_study_lite_panel_id'
	) );

	$wp_customize->add_setting('master_study_lite_woocommerce_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('master_study_lite_woocommerce_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','master-study-lite'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','master-study-lite') ."</li><li>". esc_html__('And so on...','master-study-lite') ."</li></ul><a target='_blank' href='". esc_url(MASTER_STUDY_LITE_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','master-study-lite') ."</a>",
   		 'section'=> 'master_study_lite_woocommerce_section'
 	));

	/**
	 * Product Columns
	 */
	$wp_customize->add_setting( 'master_study_lite_per_columns' , array(
		'default'           => 4,
		'transport'         => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_choices',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'master_study_lite_per_columns', array(
		'label'    => __( 'Product per columns', 'master-study-lite' ),
		'section'  => 'master_study_lite_woocommerce_section',
		'type'     => 'select',
		'choices'  => array(
			'2' => '2',
			'3' => '3',
			'4' => '4',
			'5' => '5',
		),
	) ) );

	$wp_customize->add_setting('master_study_lite_product_per_page',array(
		'default'	=> 12,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('master_study_lite_product_per_page',array(
		'label'	=> __('Product per page','master-study-lite'),
		'section'	=> 'master_study_lite_woocommerce_section',
		'type'		=> 'number'
	));

	$wp_customize->add_setting('master_study_lite_shop_sidebar_enable',array(
       'default' => false,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
    ));
    $wp_customize->add_control('master_study_lite_shop_sidebar_enable',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable shop page sidebar','master-study-lite'),
       'section' => 'master_study_lite_woocommerce_section',
    ));

   // shop page sidebar alignment
   $wp_customize->add_setting('master_study_lite_shop_page_layout', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'master_study_lite_sanitize_choices',
	));
	$wp_customize->add_control('master_study_lite_shop_page_layout',array(
		'type'           => 'radio',
		'label'          => __('Shop Page Layout', 'master-study-lite'),
		'section'        => 'master_study_lite_woocommerce_section',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'master-study-lite'),
			'Right Sidebar' => __('Right Sidebar', 'master-study-lite'),
		),
	));

	$wp_customize->add_setting('master_study_lite_product_page_sidebar_enable',array(
		'default' => false,
		'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
	));
	$wp_customize->add_control('master_study_lite_product_page_sidebar_enable',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable single product page sidebar','master-study-lite'),
		'section' => 'master_study_lite_woocommerce_section',
	));

   // single product page sidebar alignment
   $wp_customize->add_setting('master_study_lite_single_product_page_layout', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'master_study_lite_sanitize_choices',
	));
	$wp_customize->add_control('master_study_lite_single_product_page_layout',array(
		'type'           => 'radio',
		'label'          => __('Single Product Page Layout', 'master-study-lite'),
		'section'        => 'master_study_lite_woocommerce_section',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'master-study-lite'),
			'Right Sidebar' => __('Right Sidebar', 'master-study-lite'),
		),
	));

    $wp_customize->add_setting('master_study_lite_related_product_enable',array(
       'default' => true,
       'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
    ));
    $wp_customize->add_control('master_study_lite_related_product_enable',array(
       'type' => 'checkbox',
       'label' => __('Enable / Disable Related product','master-study-lite'),
       'section' => 'master_study_lite_woocommerce_section',
    ));

    $wp_customize->add_setting( 'master_study_lite_woo_product_sale_border_radius',array(
		'default' => 3,
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_woo_product_sale_border_radius', array(
        'label'  => __('Woocommerce Product Sale Border Radius','master-study-lite'),
        'section'  => 'master_study_lite_woocommerce_section',
        'type'        => 'number',
        'input_attrs' => array(
        	'step'=> 1,
            'min' => 0,
            'max' => 50,
        )
    )));

    $wp_customize->add_setting('master_study_lite_wooproduct_sale_font_size',array(
		'default'=> 14,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_wooproduct_sale_font_size',array(
		'label'	=> __('Woocommerce Product Sale Font Size','master-study-lite'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'master_study_lite_woocommerce_section',
	)));

    $wp_customize->add_setting('master_study_lite_woo_product_sale_top_bottom_padding',array(
		'default'=> 0,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_woo_product_sale_top_bottom_padding',array(
		'label'	=> __('Woocommerce Product Sale Top Bottom Padding ','master-study-lite'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'master_study_lite_woocommerce_section',
		'type'=> 'number'
	)));

	$wp_customize->add_setting('master_study_lite_woo_product_sale_left_right_padding',array(
		'default'=> 0,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_woo_product_sale_left_right_padding',array(
		'label'	=> __('Woocommerce Product Sale Left Right Padding','master-study-lite'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'master_study_lite_woocommerce_section',
		'type'=> 'number'
	)));

	$wp_customize->add_setting('master_study_lite_woo_product_sale_position',array(
        'default' => 'Left',
        'sanitize_callback' => 'master_study_lite_sanitize_choices'
	));
	$wp_customize->add_control('master_study_lite_woo_product_sale_position',array(
        'type' => 'select',
        'label' => __('Woocommerce Product Sale Position','master-study-lite'),
        'section' => 'master_study_lite_woocommerce_section',
        'choices' => array(
            'Right' => __('Right','master-study-lite'),
            'Left' => __('Left','master-study-lite'),
        ),
	));

	$wp_customize->add_setting( 'master_study_lite_woocommerce_button_padding_top',array(
		'default' => 12,
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control( new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_woocommerce_button_padding_top',	array(
		'label' => esc_html__( 'Button Top Bottom Padding (px)','master-study-lite' ),
		'section' => 'master_study_lite_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'master_study_lite_woocommerce_button_padding_right',array(
		'default' => 15,
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control( new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_woocommerce_button_padding_right',	array(
		'label' => esc_html__( 'Button Right Left Padding (px)','master-study-lite' ),
		'section' => 'master_study_lite_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'master_study_lite_woocommerce_button_border_radius',array(
		'default' => 3,
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control( new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_woocommerce_button_border_radius',array(
		'label' => esc_html__( 'Button Border Radius (px)','master-study-lite' ),
		'section' => 'master_study_lite_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

   $wp_customize->add_setting('master_study_lite_woocommerce_product_border_enable',array(
      'default' => false,
      'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
   ));
   $wp_customize->add_control('master_study_lite_woocommerce_product_border_enable',array(
      'type' => 'checkbox',
      'label' => __('Enable / Disable product border','master-study-lite'),
      'section' => 'master_study_lite_woocommerce_section',
   ));

	$wp_customize->add_setting( 'master_study_lite_woocommerce_product_padding_top',array(
		'default' => 0,
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control( new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_woocommerce_product_padding_top',	array(
		'label' => esc_html__( 'Product Top Bottom Padding (px)','master-study-lite' ),
		'section' => 'master_study_lite_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'master_study_lite_woocommerce_product_padding_right',array(
		'default' => 0,
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control( new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_woocommerce_product_padding_right',	array(
		'label' => esc_html__( 'Product Right Left Padding (px)','master-study-lite' ),
		'section' => 'master_study_lite_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'master_study_lite_woocommerce_product_border_radius',array(
		'default' => 10,
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control( new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_woocommerce_product_border_radius',array(
		'label' => esc_html__( 'Product Border Radius (px)','master-study-lite' ),
		'section' => 'master_study_lite_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'master_study_lite_woocommerce_product_box_shadow',array(
		'default' => '',
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control( new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_woocommerce_product_box_shadow',array(
		'label' => esc_html__( 'Product Box Shadow (px)','master-study-lite' ),
		'section' => 'master_study_lite_woocommerce_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting('master_study_lite_wooproducts_nav',array(
       'default' => 'Yes',
       'sanitize_callback'	=> 'master_study_lite_sanitize_choices'
    ));
    $wp_customize->add_control('master_study_lite_wooproducts_nav',array(
       'type' => 'select',
       'label' => __('Shop Page Products Navigation','master-study-lite'),
       'choices' => array(
            'Yes' => __('Yes','master-study-lite'),
            'No' => __('No','master-study-lite'),
        ),
       'section' => 'master_study_lite_woocommerce_section',
    ));

	//footer text
	$wp_customize->add_section('master_study_lite_footer_section',array(
		'title'	=> __('Footer Text','master-study-lite'),
		'panel' => 'master_study_lite_panel_id'
	));

	$wp_customize->add_setting('master_study_lite_footer_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('master_study_lite_footer_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','master-study-lite'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','master-study-lite') ."</li><li>". esc_html__('And so on...','master-study-lite') ."</li></ul><a target='_blank' href='". esc_url(MASTER_STUDY_LITE_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','master-study-lite') ."</a>",
   		 'section'=> 'master_study_lite_footer_section'
 	));
	
	$wp_customize->add_setting('master_study_lite_footer_hide',array(
		'default' => true,
		'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
	));
	$wp_customize->add_control('master_study_lite_footer_hide',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Footer','master-study-lite'),
		'section' => 'master_study_lite_footer_section',
	));	

  	$wp_customize->add_setting('master_study_lite_footer_template',array(
      'default'	=> esc_html('master_study_lite-footer-one'),
      'sanitize_callback'	=> 'master_study_lite_sanitize_choices'
	));
	$wp_customize->add_control('master_study_lite_footer_template',array(
		'label'	=> esc_html__('Footer style','master-study-lite'),
		'section'	=> 'master_study_lite_footer_section',
		'setting'	=> 'master_study_lite_footer_template',
		'type' => 'select',
		'choices' => array(
          'master_study_lite-footer-one' => esc_html__('Style 1', 'master-study-lite'),
          'master_study_lite-footer-two' => esc_html__('Style 2', 'master-study-lite'),
          'master_study_lite-footer-three' => esc_html__('Style 3', 'master-study-lite'),
          'master_study_lite-footer-four' => esc_html__('Style 4', 'master-study-lite'),
          'master_study_lite-footer-five' => esc_html__('Style 5', 'master-study-lite'),
          )
	));		

	$wp_customize->add_setting('master_study_lite_footer_bg_color', array(
		'default'           => '#000',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_footer_bg_color', array(
		'label'    => __('Footer Background Color', 'master-study-lite'),
		'section'  => 'master_study_lite_footer_section',
	)));

	$wp_customize->add_setting('master_study_lite_footer_bg_image',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'master_study_lite_footer_bg_image',array(
		'label' => __('Footer Background Image','master-study-lite'),
		'section' => 'master_study_lite_footer_section'
	)));
	
	$wp_customize->add_setting('master_study_lite_footer_attatchment',array(
		'default'=> 'scroll',
		'sanitize_callback'	=> 'master_study_lite_sanitize_choices'
	));
	$wp_customize->add_control('master_study_lite_footer_attatchment',array(
		'type' => 'select',
		'label'	=> __('Footer Background Attatchment','master-study-lite'),
		'choices' => array(
            'fixed' => __('fixed','master-study-lite'),
            'scroll' => __('scroll','master-study-lite'),
        ),
		'section'=> 'master_study_lite_footer_section',
	));

	$wp_customize->add_setting('master_study_lite_footer_img_position',array(
		'default' => 'center center',
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_choices'
	  ));
	  $wp_customize->add_control('master_study_lite_footer_img_position',array(
		  'type' => 'select',
		  'label' => __('Footer Image Position','master-study-lite'),
		  'section' => 'master_study_lite_footer_section',
		  'choices' 	=> array(
			  'left top' 		=> esc_html__( 'Top Left', 'master-study-lite' ),
			  'center top'   => esc_html__( 'Top', 'master-study-lite' ),
			  'right top'   => esc_html__( 'Top Right', 'master-study-lite' ),
			  'left center'   => esc_html__( 'Left', 'master-study-lite' ),
			  'center center'   => esc_html__( 'Center', 'master-study-lite' ),
			  'right center'   => esc_html__( 'Right', 'master-study-lite' ),
			  'left bottom'   => esc_html__( 'Bottom Left', 'master-study-lite' ),
			  'center bottom'   => esc_html__( 'Bottom', 'master-study-lite' ),
			  'right bottom'   => esc_html__( 'Bottom Right', 'master-study-lite' ),
		  ),
	  ));		

	$wp_customize->add_setting('master_study_lite_footer_widget_areas',array(
		'default'           => 4,
		'sanitize_callback' => 'master_study_lite_sanitize_choices',
	));
	$wp_customize->add_control('master_study_lite_footer_widget_areas',array(
		'type'        => 'radio',
		'label'       => __('Footer widget area', 'master-study-lite'),
		'section'     => 'master_study_lite_footer_section',
		'description' => __('Select the number of widget areas you want in the footer. After that, go to Appearance > Widgets and add your widgets.', 'master-study-lite'),
		'choices' => array(
		   '1'     => __('One', 'master-study-lite'),
		   '2'     => __('Two', 'master-study-lite'),
		   '3'     => __('Three', 'master-study-lite'),
		   '4'     => __('Four', 'master-study-lite')
		),
	));

	$wp_customize->add_setting('master_study_lite_footer_heading',array(
	    'default' => 'Left',
	    'transport' => 'refresh',
	    'sanitize_callback' => 'master_study_lite_sanitize_choices'
	));
	$wp_customize->add_control('master_study_lite_footer_heading',array(
	    'type' => 'select',
	    'label' => __('Footer Heading Alignment','master-study-lite'),
	    'section' => 'master_study_lite_footer_section',
	    'choices' => array(
	    	'Left' => __('Left','master-study-lite'),
	        'Center' => __('Center','master-study-lite'),
	        'Right' => __('Right','master-study-lite')
	    ),
	) );

	$wp_customize->add_setting('master_study_lite_footer_heading_font_weight',array(
		'default' => '',
		'sanitize_callback' => 'master_study_lite_sanitize_choices'
 	));
 	$wp_customize->add_control('master_study_lite_footer_heading_font_weight',array(
		'type' => 'select',
		'label' => __('Footer Heading Font Weight','master-study-lite'),
		'section' => 'master_study_lite_footer_section',
		'choices' => array(
			'100' => __('100','master-study-lite'),
			'200' => __('200','master-study-lite'),
			'300' => __('300','master-study-lite'),
			'400' => __('400','master-study-lite'),
			'500' => __('500','master-study-lite'),
			'600' => __('600','master-study-lite'),
			'700' => __('700','master-study-lite'),
			'800' => __('800','master-study-lite'),
			'900' => __('900','master-study-lite'),
		),
	) );

	$wp_customize->add_setting('master_study_lite_footer_heading_letter_spacing',array(
		'default'=> 1,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('master_study_lite_footer_heading_letter_spacing',array(
		'label'	=> __('Footer Heading Letter Spacing','master-study-lite'),
  		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
	),
		'section'=> 'master_study_lite_footer_section',
	));		

	$wp_customize->add_setting('master_study_lite_footer_content',array(
	    'default' => 'Left',
	    'transport' => 'refresh',
	    'sanitize_callback' => 'master_study_lite_sanitize_choices'
	));
	$wp_customize->add_control('master_study_lite_footer_content',array(
	    'type' => 'select',
	    'label' => __('Footer Content Alignment','master-study-lite'),
	    'section' => 'master_study_lite_footer_section',
	    'choices' => array(
	    	'Left' => __('Left','master-study-lite'),
	        'Center' => __('Center','master-study-lite'),
	        'Right' => __('Right','master-study-lite')
	    ),
	) );

	$wp_customize->add_setting('master_study_lite_footer_heading_font_size',array(
		'default'=> 25,
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control(new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_footer_heading_font_size',array(
		'label' => esc_html__( 'Footer Heading Font Size','master-study-lite' ),
		'section'=> 'master_study_lite_footer_section',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
	)));

	$wp_customize->add_setting('master_study_lite_footer_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Custom_Control( $wp_customize,'master_study_lite_footer_padding',array(
		'label'	=> __('Footer Widget Padding','master-study-lite'),
		'section'=> 'master_study_lite_footer_section',
		'input_attrs' => array(
         'step' => 1,
			'min'  => 0,
			'max'  => 100,
      ),
	)));

	$wp_customize->add_setting('master_study_lite_hide_show_scroll',array(
		'default' => true,
		'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
	));
	$wp_customize->add_control('master_study_lite_hide_show_scroll',array(
     	'type' => 'checkbox',
      	'label' => __('Enable / Disable Back To Top','master-study-lite'),
      	'section' => 'master_study_lite_footer_section',
	));

	$wp_customize->add_setting('master_study_lite_back_to_top_icon',array(
		'default'	=> 'fas fa-long-arrow-alt-up',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
        $wp_customize,'master_study_lite_back_to_top_icon',array(
		'label'	=> __('Back to Top Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_footer_section',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('master_study_lite_scroll_icon_font_size',array(
		'default'=> 22,
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control(new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_scroll_icon_font_size',array(
		'label'	=> __('Back To Top Icon Font Size','master-study-lite'),
		'section'=> 'master_study_lite_footer_section',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
	)));

	$wp_customize->add_setting('master_study_lite_scroll_icon_color', array(
		'default'           => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_scroll_icon_color', array(
		'label'    => __('Back to Top Icon Color', 'master-study-lite'),
		'section'  => 'master_study_lite_footer_section',
	)));

	$wp_customize->add_setting('master_study_lite_scroll_icon_hover_color', array(
		'default'           => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_scroll_icon_hover_color', array(
		'label'    => __('Back to Top Icon Hover Color', 'master-study-lite'),
		'section'  => 'master_study_lite_footer_section',
	)));

	$wp_customize->add_setting('master_study_lite_scroll_icon_background', array(
		'default'           => 'var(--first-theme-color)',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_scroll_icon_background', array(
		'label'    => __('Back to Top Background Color', 'master-study-lite'),
		'section'  => 'master_study_lite_footer_section',
	)));

	$wp_customize->add_setting('master_study_lite_scroll_icon_background_hover', array(
		'default'           => 'var(--first-theme-color)',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_scroll_icon_background_hover', array(
		'label'    => __('Back to Top Background Hover Color', 'master-study-lite'),
		'section'  => 'master_study_lite_footer_section',
	)));

	$wp_customize->add_setting('master_study_lite_footer_options',array(
        'default' => 'Right align',
        'sanitize_callback' => 'master_study_lite_sanitize_choices'
	));
	$wp_customize->add_control('master_study_lite_footer_options',array(
        'type' => 'radio',
        'label' => __('Back To Top Alignment','master-study-lite'),
        'section' => 'master_study_lite_footer_section',
        'choices' => array(
            'Left align' => __('Left Align','master-study-lite'),
            'Right align' => __('Right Align','master-study-lite'),
            'Center align' => __('Center Align','master-study-lite'),
        ),
	) );

	$wp_customize->add_setting( 'master_study_lite_top_bottom_scroll_padding',array(
		'default' => 7,
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control( new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_top_bottom_scroll_padding',	array(
		'label' => esc_html__( 'Top Bottom Scroll Padding (px)','master-study-lite' ),
		'section' => 'master_study_lite_footer_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'master_study_lite_left_right_scroll_padding',array(
		'default' => 17,
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control( new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_left_right_scroll_padding',	array(
		'label' => esc_html__( 'Left Right Scroll Padding (px)','master-study-lite' ),
		'section' => 'master_study_lite_footer_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting( 'master_study_lite_back_to_top_border_radius',array(
		'default' => 5,
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control( new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_back_to_top_border_radius', array(
		'label' => esc_html__( 'Back to Top Border Radius (px)','master-study-lite' ),
		'section' => 'master_study_lite_footer_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting('master_study_lite_copyright_hide',array(
		'default' => true,
		'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
	));
	$wp_customize->add_control('master_study_lite_copyright_hide',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Copyright','master-study-lite'),
		'section' => 'master_study_lite_footer_section',
	));	

	$wp_customize->add_setting('master_study_lite_footer_copy',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('master_study_lite_footer_copy',array(
		'label'	=> __('Copyright Text','master-study-lite'),
		'section'	=> 'master_study_lite_footer_section',
		'description'	=> __('Add some text for footer like copyright etc.','master-study-lite'),
		'type'		=> 'text'
	));

	$wp_customize->add_setting('master_study_lite_footer_text_align',array(
        'default' => 'center',
        'sanitize_callback' => 'master_study_lite_sanitize_choices'
	));
	$wp_customize->add_control('master_study_lite_footer_text_align',array(
        'type' => 'radio',
        'label' => __('Copyright Text Alignment ','master-study-lite'),
        'section' => 'master_study_lite_footer_section',
        'choices' => array(
            'left' => __('Left Align','master-study-lite'),
            'right' => __('Right Align','master-study-lite'),
            'center' => __('Center Align','master-study-lite'),
        ),
	) );

	$wp_customize->add_setting('master_study_lite_copyright_text_font_size',array(
		'default'=> 15,
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control(new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_copyright_text_font_size',array(
		'label' => esc_html__( 'Copyright Font Size (px)','master-study-lite' ),
		'section'=> 'master_study_lite_footer_section',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
	)));

	$wp_customize->add_setting( 'master_study_lite_footer_text_padding',array(
		'default' => 20,
		'transport' => 'refresh',
		'sanitize_callback' => 'master_study_lite_sanitize_integer'
	));
	$wp_customize->add_control( new Master_Study_Lite_Custom_Control( $wp_customize, 'master_study_lite_footer_text_padding',	array(
		'label' => esc_html__( 'Copyright Text Padding (px)','master-study-lite' ),
		'section' => 'master_study_lite_footer_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	)));

	$wp_customize->add_setting('master_study_lite_copyright_text_color', array(
		'default'           => '#ffffff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_copyright_text_color', array(
		'label'    => __('Copyright Text Color', 'master-study-lite'),
		'section'  => 'master_study_lite_footer_section',
	)));

	$wp_customize->add_setting('master_study_lite_copyright_text_hover_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_copyright_text_hover_color', array(
		'label'    => __('Copyright Text Hover Color', 'master-study-lite'),
		'section'  => 'master_study_lite_footer_section',
	)));	

	$wp_customize->add_setting('master_study_lite_copyright_text_background', array(
		'default'           => 'var(--first-theme-color)',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_copyright_text_background', array(
		'label'    => __('Copyright background Color', 'master-study-lite'),
		'section'  => 'master_study_lite_footer_section',
	)));

	//Footer Social Icons
	$wp_customize->add_section('master_study_lite_footer_social_icons',array(
		'title'	=> __('Footer Social Icons','master-study-lite'),
		'priority'	=> null,
		'panel' => 'master_study_lite_panel_id',
	));

	$wp_customize->add_setting('master_study_lite_footer_social_icons_premium_info',array(
    	'sanitize_callback' => 'sanitize_text_field'
 	));
 	$wp_customize->add_control('master_study_lite_footer_social_icons_premium_info',array(
   		 'type'=> 'hidden',
   		 'label' => __('Premium Features','master-study-lite'),
   		 'description' => "<ul><li>". esc_html__('Please explore our premium theme for additional settings and features.','master-study-lite') ."</li><li>". esc_html__('And so on...','master-study-lite') ."</li></ul><a target='_blank' href='". esc_url(MASTER_STUDY_LITE_BUY_PRO) ." '>". esc_html__('Upgrade to Pro','master-study-lite') ."</a>",
   		 'section'=> 'master_study_lite_footer_social_icons'
 	));

	 $wp_customize->add_setting('master_study_lite_footer_social_hide',array(
		'default' => false,
		'sanitize_callback'	=> 'master_study_lite_sanitize_checkbox'
	));
	$wp_customize->add_control('master_study_lite_footer_social_hide',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Footer Icons','master-study-lite'),
		'section' => 'master_study_lite_footer_social_icons',
	));	

	$wp_customize->add_setting('master_study_lite_footer_facebook_url',array(
		'default' => '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('master_study_lite_footer_facebook_url',array(
		'type' => 'url',
		'label' => __('Add Facebook URL','master-study-lite'),
		'section' => 'master_study_lite_footer_social_icons',
	));

	$wp_customize->add_setting('master_study_lite_footer_facebook_icon',array(
		'default'	=> 'fab fa-facebook-f',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
        $wp_customize,'master_study_lite_footer_facebook_icon',array(
		'label'	=> __('Choose Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_footer_social_icons',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('master_study_lite_footer_instagram_url',array(
		'default' => '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('master_study_lite_footer_instagram_url',array(
		'type' => 'url',
		'label' => __('Add Instagram URL','master-study-lite'),
		'section' => 'master_study_lite_footer_social_icons',
	));

	$wp_customize->add_setting('master_study_lite_footer_instagram_icon',array(
		'default'	=> 'fab fa-instagram',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
        $wp_customize,'master_study_lite_footer_instagram_icon',array(
		'label'	=> __('Choose Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_footer_social_icons',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('master_study_lite_footer_twitter_url',array(
		'default' => '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('master_study_lite_footer_twitter_url',array(
		'type' => 'url',
		'label' => __('Add Twitter URL','master-study-lite'),
		'section' => 'master_study_lite_footer_social_icons',
	));

	$wp_customize->add_setting('master_study_lite_footer_twitter_icon',array(
		'default'	=> 'fab fa-twitter',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
        $wp_customize,'master_study_lite_footer_twitter_icon',array(
		'label'	=> __('Choose Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_footer_social_icons',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('master_study_lite_footer_linkedin_url',array(
		'default' => '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('master_study_lite_footer_linkedin_url',array(
		'type' => 'url',
		'label' => __('Add LinkedIn URL','master-study-lite'),
		'section' => 'master_study_lite_footer_social_icons',
	));

	$wp_customize->add_setting('master_study_lite_footer_linkedin_icon',array(
		'default'	=> 'fa-brands fa-linkedin-in',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Master_Study_Lite_Icon_Changer(
        $wp_customize,'master_study_lite_footer_linkedin_icon',array(
		'label'	=> __('Choose Icon','master-study-lite'),
		'transport' => 'refresh',
		'section'	=> 'master_study_lite_footer_social_icons',
		'type'		=> 'icon'
	)));	

	$wp_customize->add_setting('master_study_lite_footer_social_icons_size', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('master_study_lite_footer_social_icons_size', array(
		'label'   => __('Icon Font Size', 'master-study-lite'),
		'section' => 'master_study_lite_footer_social_icons',
		'setting' => 'master_study_lite_footer_social_icons_size',
		'type'    => 'text',
	));

	$wp_customize->add_setting('master_study_lite_footer_icon_alignment',array(
        'default' => 'center',
        'sanitize_callback' => 'master_study_lite_sanitize_choices'
	));
	$wp_customize->add_control('master_study_lite_footer_icon_alignment',array(
        'type' => 'radio',
        'label' => __('Icon Alignment ','master-study-lite'),
        'section' => 'master_study_lite_footer_social_icons',
        'choices' => array(
            'left' => __('Left Align','master-study-lite'),
            'right' => __('Right Align','master-study-lite'),
            'center' => __('Center Align','master-study-lite'),
        ),
	) );	

	$wp_customize->add_setting('master_study_lite_footer_icon_color_option', array(
		'default'           => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'master_study_lite_footer_icon_color_option', array(
		'label'    => __('Icon Color', 'master-study-lite'),
		'section'  => 'master_study_lite_footer_social_icons',
	)));

	//Reset All Settings
	$wp_customize->add_section( 'master_study_lite_reset_section', array(
		'title'    => __( 'Reset Theme Settings', 'master-study-lite' ),
		'priority'	=> null,
		'panel' => 'master_study_lite_panel_id',
	) );

	//Reset Demo Import
	$wp_customize->add_setting( 'master_study_lite_reset_demo_import_settings', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control('master_study_lite_reset_demo_import_settings',array(
			'label'   => __( 'Reset Demo Import', 'master-study-lite' ),
			'section' => 'master_study_lite_reset_section',
			'type'    => 'button',
			'input_attrs' => array(
				'onclick' => 'ResetDemoSettings()',
			),
	));

	//Reset Global Color
	$wp_customize->add_setting('master_study_lite_reset_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));

	$wp_customize->add_control('master_study_lite_reset_color', array(
		'type'    => 'button',
		'label'   => __('Reset Global Color', 'master-study-lite'),
		'section' => 'master_study_lite_reset_section',
		'input_attrs' => array(
			'onclick' => 'ResetGlobalColor()',
		),
	));

}
add_action( 'customize_register', 'master_study_lite_customize_register' );

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Master_Study_Lite_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Master_Study_Lite_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Master_Study_Lite_Customize_Section_Pro(
				$manager,
				'master_study_lite_example_1',
				array(
					'title'   =>  esc_html__( 'Master Study Lite Pro', 'master-study-lite' ),
					'pro_text' => esc_html__( 'Get Pro', 'master-study-lite' ),
					'pro_url'  => esc_url( 'https://www.buywptemplates.com/products/education-wordpress-theme' ),
					'priority'   => 9
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'master-study-lite-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'master-study-lite-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/css/customize-controls.css' );
	}

	function master_study_lite_sanitize_choices( $input ) {
		$valid = array(
			'1'     => __('One', 'master-study-lite'),
			'2'     => __('Two', 'master-study-lite'),
			'3'     => __('Three', 'master-study-lite'),
			'4'     => __('Four', 'master-study-lite')
		);
		if ( array_key_exists( $input, $valid ) ) {
			return $input;
		} else {
	  		return '';
		}
	}

}

// Doing this customizer thang!
Master_Study_Lite_Customize::get_instance();