<div class="theme-offer">
	<?php
        // Check if the demo import has been completed
        $master_study_lite_demo_import_completed = get_option('master_study_lite_demo_import_completed', false);

        // If the demo import is completed, display the "View Site" button
        if ($master_study_lite_demo_import_completed) {
        echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'master-study-lite') . '</p>';
        echo '<span><a href="' . esc_url(home_url()) . '" class="site-btn" target="_blank">' . esc_html__('VIEW SITE', 'master-study-lite') . '</a></span>';
        }
		
        if (isset($_POST['submit'])) {

            // Check if ace-post-type-builder is installed and activated
            if (!is_plugin_active('ace-post-type-builder/ace-post-type-builder.php')) {
                // Install the plugin if it doesn't exist
                $master_study_lite_plugin_slug = 'ace-post-type-builder';
                $master_study_lite_plugin_file = 'ace-post-type-builder/ace-post-type-builder.php';

                // Check if plugin is installed
                $master_study_lite_installed_plugins = get_plugins();
                if (!isset($master_study_lite_installed_plugins[$master_study_lite_plugin_file])) {
                    include_once(ABSPATH . 'wp-admin/includes/plugin-install.php');
                    include_once(ABSPATH . 'wp-admin/includes/file.php');
                    include_once(ABSPATH . 'wp-admin/includes/misc.php');
                    include_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');

                    // Install the plugin
                    $master_study_lite_upgrader = new Plugin_Upgrader();
                    $master_study_lite_upgrader->install('https://downloads.wordpress.org/plugin/ace-post-type-builder.latest-stable.zip');
                }
                // Activate the plugin
                activate_plugin($master_study_lite_plugin_file);
            }

            // ------- Create Nav Menu --------
            $master_study_lite_menuname = 'Main Menus';
            $master_study_lite_bpmenulocation = 'primary';
            $master_study_lite_menu_exists = wp_get_nav_menu_object($master_study_lite_menuname);

            if (!$master_study_lite_menu_exists) {
                $master_study_lite_menu_id = wp_create_nav_menu($master_study_lite_menuname);

                // Create Home Page
                $master_study_lite_home_title = 'Home';
                $master_study_lite_home = array(
                    'post_type' => 'page',
                    'post_title' => $master_study_lite_home_title,
                    'post_content' => '',
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'home'
                );
                $master_study_lite_home_id = wp_insert_post($master_study_lite_home);
                // Assign Home Page Template
                add_post_meta($master_study_lite_home_id, '_wp_page_template', 'page-template/home-page.php');
                // Update options to set Home Page as the front page
                update_option('page_on_front', $master_study_lite_home_id);
                update_option('show_on_front', 'page');
                // Add Home Page to Menu
                wp_update_nav_menu_item($master_study_lite_menu_id, 0, array(
                    'menu-item-title' => __('Home', 'master-study-lite'),
                    'menu-item-classes' => 'home',
                    'menu-item-url' => home_url('/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $master_study_lite_home_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Pages Page with Dummy Content
                $master_study_lite_about_title = 'About Us';
                $master_study_lite_about_content = 'Explore all the about we have on our website. Find information about our services, company, and more.
                 Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more contactly with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br>
                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $master_study_lite_about = array(
                    'post_type' => 'page',
                    'post_title' => $master_study_lite_about_title,
                    'post_content' => $master_study_lite_about_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'about'
                );
                $master_study_lite_about_id = wp_insert_post($master_study_lite_about);
                // Add Pages Page to Menu
                wp_update_nav_menu_item($master_study_lite_menu_id, 0, array(
                    'menu-item-title' => __('about', 'master-study-lite'),
                    'menu-item-classes' => 'about',
                    'menu-item-url' => home_url('/about/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $master_study_lite_about_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Pages Page with Dummy Content
                $master_study_lite_contact_title = 'Contact Us';
                $master_study_lite_contact_content = 'Explore all the contact we have on our website. Find information about our services, company, and more.
                 Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more contactly with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br>
                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $master_study_lite_contact = array(
                    'post_type' => 'page',
                    'post_title' => $master_study_lite_contact_title,
                    'post_content' => $master_study_lite_contact_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'contact'
                );
                $master_study_lite_contact_id = wp_insert_post($master_study_lite_contact);
                // Add Pages Page to Menu
                wp_update_nav_menu_item($master_study_lite_menu_id, 0, array(
                    'menu-item-title' => __('Contact', 'master-study-lite'),
                    'menu-item-classes' => 'contact',
                    'menu-item-url' => home_url('/contact/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $master_study_lite_contact_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));


                // Set the menu location if it's not already set
                if (!has_nav_menu($master_study_lite_bpmenulocation)) {
                    $master_study_lite_locations = get_theme_mod('nav_menu_locations'); // Use 'nav_menu_locations' to get locations array
                    if (empty($master_study_lite_locations)) {
                        $master_study_lite_locations = array();
                    }
                    $master_study_lite_locations[$master_study_lite_bpmenulocation] = $master_study_lite_menu_id;
                    set_theme_mod('nav_menu_locations', $master_study_lite_locations);
                }
            }

            // Assign the menu to the theme location
            set_theme_mod('nav_menu_locations', [$master_study_lite_bpmenulocation => $master_study_lite_menu_id]);
                        
            // Set the demo import completion flag
    		update_option('master_study_lite_demo_import_completed', true);
    		// Display success message and "View Site" button
    		echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'master-study-lite') . '</p>';
    		echo '<span><a href="' . esc_url(home_url()) . '" class="button button-primary site-btn" target="_blank">' . esc_html__('VIEW SITE', 'master-study-lite') . '</a></span>';
            //end

            //Header      
            set_theme_mod( 'master_study_lite_topbar_hide', true );
            set_theme_mod( 'master_study_lite_top_sidebar_phone_number', '+00 123 456 789' );
            set_theme_mod( 'master_study_lite_top_sidebar_email_address', 'masterstudy12@example.com' );
            set_theme_mod( 'master_study_lite_facebook_url', '#' );
            set_theme_mod( 'master_study_lite_twitter_url', '#' );
            set_theme_mod( 'master_study_lite_instagram_url', '#' );

            //Slider Section
            set_theme_mod( 'master_study_lite_slider_hide', true );

            $master_study_lite_slider_data = array(
                array(
                    'bg_image' => get_template_directory_uri() . '/images/slider1.png',
                    'small_text' => 'Welcome To',
                    'title' => 'Master Study Lite',
                    'small_title' => 'Intercultural Institute Of Language',                   
                    'btn_text' => 'Read More'
                ),
                array(
                    'bg_image' => get_template_directory_uri() . '/images/slider2.png',
                    'small_text' => 'Explore Knowledge',
                    'title' => 'Advanced Learning',
                    'small_title' => 'Enhance Your Skills With Us',                   
                    'btn_text' => 'Read More'
                ),
                array(
                    'bg_image' => get_template_directory_uri() . '/images/slider3.png',
                    'small_text' => 'Join The Community',
                    'title' => 'Global Education',
                    'small_title' => 'Connect With Experts Worldwide',                   
                    'btn_text' => 'Read More'
                ),
            );                        
        
            set_theme_mod('master_study_lite_slide_number', count($master_study_lite_slider_data));
        
            foreach ($master_study_lite_slider_data as $master_study_lite_index => $master_study_lite_data) {
                $master_study_lite_i = $master_study_lite_index + 1;
        
                set_theme_mod("master_study_lite_slider_bg_image$master_study_lite_i", $master_study_lite_data['bg_image']);           
                set_theme_mod("master_study_lite_slider_small_title$master_study_lite_i", $master_study_lite_data['small_text']);
                set_theme_mod("master_study_lite_slider_title$master_study_lite_i", $master_study_lite_data['title']);
                set_theme_mod("master_study_lite_slider_desc_text$master_study_lite_i", $master_study_lite_data['small_title']);
                set_theme_mod("master_study_lite_slider_btn_text$master_study_lite_i", $master_study_lite_data['btn_text']);
            }

            //Faculties Section
            set_theme_mod( 'master_study_lite_section_title', 'OUR FACULTIES' );

            $master_study_lite_team_members = array(
                array(
                    'image' => get_template_directory_uri() . '/images/Team/team1.png',
                    'name' => 'Anna Beyone',
                    'designation' => 'DIRECTOR',
                    'description' => 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.',                
                ),
                array(
                    'image' => get_template_directory_uri() . '/images/Team/team2.png',
                    'name' => 'Amith Taylor',
                    'designation' => 'DIRECTOR',
                    'description' => 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.', 
                ),
                array(
                    'image' => get_template_directory_uri() . '/images/Team/team3.png',
                    'name' => 'Sarah Grace',
                    'designation' => 'DIRECTOR',
                    'description' => 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.', 
                ),
            );
        
            foreach ($master_study_lite_team_members as $master_study_lite_key => $master_study_lite_member) {
                $master_study_lite_index = $master_study_lite_key + 1;
                set_theme_mod('master_study_lite_faculties_image' . $master_study_lite_index, $master_study_lite_member['image']);
                set_theme_mod('master_study_lite_member_name' . $master_study_lite_index, $master_study_lite_member['name']);
                set_theme_mod('master_study_lite_add_designation' . $master_study_lite_index, $master_study_lite_member['designation']);
                set_theme_mod('master_study_lite_add_description' . $master_study_lite_index, $master_study_lite_member['description']);
            }
           
            //Copyright Text
            set_theme_mod( 'master_study_lite_footer_text', 'By Buywptemplate' );

        }
    ?>

    <form action="<?php echo esc_url(home_url()); ?>/wp-admin/themes.php?page=master-study-lite-guide-page" method="POST" onsubmit="return validate(this);">
    <?php if (!get_option('master_study_lite_demo_import_completed')) : ?>
        <form method="post">
        <p><?php esc_html_e('Click the below run importer button to import demo content','master-study-lite'); ?></p>
            <input class= "run-import" type="submit" name="submit" value="<?php esc_attr_e('Run Importer','master-study-lite'); ?>" class="button button-primary button-large">
        </form>
    <?php endif; ?>
    </form>
	<script type="text/javascript">
		function validate(valid) {
			 if(confirm("Do you really want to import the theme demo content?")){
			    document.forms[0].submit();
			}
		    else {
			    return false;
		    }
		}
	</script>
</div>
