( function( api ) {

	// Extends our custom "master-study-lite" section.
	api.sectionConstructor['master-study-lite'] = api.Section.extend( {

		// No events for this type of section.
		attachEvents: function () {},

		// Always make the section active.
		isContextuallyActive: function () {
			return true;
		}
	} );

} )( wp.customize );

(function ($) {
    function ResetDemoSettings() {
        if (!confirm("Are you sure you want to reset demo import settings?")) return;

        $.post(ajaxurl, { action: 'master_study_lite_reset_demo_import_settings' }, function () {
            location.reload();
        });
    }

    window.ResetDemoSettings = ResetDemoSettings;
})(jQuery);

(function ($, wp) {
    function ResetGlobalColor() {
        if (confirm("Are you sure you want to reset global color settings?")) {
            wp.customize.instance("master_study_lite_first_color").set("#F2277E");
			wp.customize.instance("master_study_lite_second_color").set("#3677FF");
        }
    }

    window.ResetGlobalColor = ResetGlobalColor;
})(jQuery, wp);
