<?php

class PxlCounterBox_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_counter_box';
    protected $title = 'BR Counter Box';
    protected $icon = 'eicon-counter-circle';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"section_content","label":"Content","tab":"content","controls":[{"name":"content_general","label":"GENERAL","type":"heading","saperator":"after"},{"name":"title","label":"Title","type":"text","label_block":true},{"name":"desc","label":"Description","type":"text","label_block":true},{"name":"prefix","label":"Prefix","type":"text","default":""},{"name":"suffix","label":"Suffix","type":"text","default":""},{"name":"thousand_separator_char","label":"Separator","type":"select","options":{"":"Default",".":"Dot",",":"Comma"," ":"Space"},"default":""},{"name":"divider","type":"divider"},{"name":"content_number","label":"NUMBER","type":"heading","saperator":"after"},{"name":"starting_number","label":"Starting","type":"number","default":1},{"name":"ending_number","label":"Ending","type":"number","default":100},{"name":"duration","label":"Duration","type":"number","default":2000,"min":100,"step":100},{"name":"divider1","type":"divider"},{"name":"content_layer","label":"LAYER","type":"heading","saperator":"after"},{"name":"layer","label":"Layer","type":"media"},{"name":"img_size","label":"Size","type":"text","description":"Enter size (Example: \"thumbnail\", \"medium\", \"large\", \"full\" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height)."},{"name":"layer_effect","label":"Effect","type":"select","options":{"":"None","pxl-image-effect1":"Zigzag","pxl-image-spin":"Spin","pxl-image-zoom":"Zoom 1","pxl-image-zoom2":"Zoom 2","pxl-image-bounce":"Bounce","slide-up-down":"Slide Up Down","slide-in-tr":"Slide Top Right To Bottom Left","slide-in-bl":"Slide Bottom Left To Top Right","slide-top-to-bottom":"Slide Top To Bottom ","pxl-image-effect2":"Slide Bottom To Top ","slide-right-to-left":"Slide Right To Left ","slide-left-to-right":"Slide Left To Right ","pxl-animation-round":"Round"},"default":""}]},{"name":"section_style_general","label":"General","tab":"style","controls":[{"name":"effect","label":"Effect","type":"select","options":{"effect-default":"Default","effect-slide":"Slide"},"default":"effect-default"},{"name":"bg_color","label":"Background Color","type":"color","condition":{"style_l2!":"box-linear-gradient"},"selectors":{"{{WRAPPER}} .pxl-counter-box .pxl-item--container":"background-color: {{VALUE}};"}},{"name":"box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-counter-box .pxl-item--container"},{"name":"content_max_width","label":"Max Width","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-counter-box .pxl-item--inner":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"content_min_height","label":"Min Height","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-counter-box .pxl-item--inner":"min-height: {{SIZE}}{{UNIT}};"}},{"name":"border_radius","label":"Border Radius","type":"dimensions","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-counter-box .pxl-item--container":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"padding","label":"Padding","type":"dimensions","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-counter-box .pxl-item--inner":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"section_style_number","label":"Number","tab":"style","controls":[{"name":"number_style","label":"NUMBER","type":"heading","saperator":"after"},{"name":"number_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter-box .pxl-item--number":"color: {{VALUE}};"}},{"name":"number_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-counter-box .pxl-item--number"},{"name":"affix_color","label":"Affix Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter-box .pxl-item--number .pxl-item--suffix, \r\n                                {{WRAPPER}} .pxl-counter-box .pxl-item--number .pxl-item--prefix":"color: {{VALUE}};"}},{"name":"number_spacing_bottom","label":"Bottom Spacer","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-counter-box .pxl-item--number":"margin-bottom: {{SIZE}}{{UNIT}};"}}]},{"name":"section_style_title","label":"Title","tab":"style","controls":[{"name":"title_style","label":"NORMAL","type":"heading","saperator":"after"},{"name":"title_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter-box .pxl-item--inner .pxl-item--title":"color: {{VALUE}};"}},{"name":"title_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-counter-box .pxl-item--inner .pxl-item--title"},{"name":"title_spacing_bottom","label":"Spacing Bottom","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-counter-box .pxl-item--inner .pxl-item--title":"margin-bottom: {{SIZE}}{{UNIT}};"}},{"name":"divider2","type":"divider"},{"name":"highlight_style","label":"HIGHLIGHT","type":"heading","saperator":"after"},{"name":"title_highlight_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter-box .pxl-item--inner .pxl-item--title .pxl-title--highlight":"color: {{VALUE}};"}},{"name":"title_highlight_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-counter-box .pxl-item--inner .pxl-item--title .pxl-title--highlight"}]},{"name":"section_style_desc","label":"Description","tab":"style","controls":[{"name":"desc_style","label":"NORMAL","type":"heading","saperator":"after"},{"name":"desc_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter-box .pxl-item--inner .pxl-item--desc":"color: {{VALUE}};"}},{"name":"desc_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-counter-box .pxl-item--inner .pxl-item--desc"}]},{"name":"section_animation","label":"Animation","tab":"style","condition":[],"controls":[{"name":"pxl_animate","label":"Bravis Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","bounce-top wow":"bounceTop","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipCase":"flipCase","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomInSmall":"zoomInSmall","wow zoomIn":"zoomInBig","wow zoomOut":"zoomOut","wow skewIn":"skewInLeft","wow skewInRight":"skewInRight","wow skewInBottom":"skewInBottom","wow skewInTop":"skewInTop","wow RotatingY":"RotatingY","wow PXLfadeInUp":"PXLfadeInUp","fadeInPopup":"fadeInPopup","wow pxl-expanding-line-effect":"Expanding Line Effect"},"default":""},{"name":"pxl_animate_delay","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'elementor-waypoints','jquery-numerator','pxl-counter','pxl-counter-slide','gurus-counter' );
}