<?php

class PxlCounter_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_counter';
    protected $title = 'BR Counter';
    protected $icon = 'eicon-counter-circle';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"section_layout","label":"Layout","tab":"layout","controls":[{"name":"layout","label":"Templates","type":"layoutcontrol","default":"1","options":{"1":{"label":"Layout 1","image":"https:\/\/mel-ng.com\/wp-content\/themes\/gurus\/elements\/widgets\/img-layout\/pxl_counter\/counter1.webp"},"2":{"label":"Layout 2","image":"https:\/\/mel-ng.com\/wp-content\/themes\/gurus\/elements\/widgets\/img-layout\/pxl_counter\/counter2.webp"},"3":{"label":"Layout 3","image":"https:\/\/mel-ng.com\/wp-content\/themes\/gurus\/elements\/widgets\/img-layout\/pxl_counter\/counter3.webp"},"4":{"label":"Layout 4","image":"https:\/\/mel-ng.com\/wp-content\/themes\/gurus\/elements\/widgets\/img-layout\/pxl_counter\/counter4.webp"}}}]},{"name":"section_content","label":"Content","tab":"content","controls":[{"name":"title","label":"Title","type":"text","label_block":true,"default":"Enter title here."},{"name":"starting_number","label":"Starting Number","type":"number","default":1},{"name":"ending_number","label":"Ending Number","type":"number","default":100},{"name":"prefix","label":"Number Prefix","type":"text","default":""},{"name":"suffix","label":"Number Suffix","type":"text","default":""},{"name":"thousand_separator_char","label":"Number Separator","type":"select","options":{"":"Default",".":"Dot",",":"Comma"," ":"Space"},"default":""},{"name":"icon_type","label":"Icon Type","type":"select","options":{"icon":"Icon","image":"Image"},"default":"icon"},{"name":"pxl_icon","label":"Icon","type":"icons","fa4compatibility":"icon","condition":{"icon_type":"icon"}},{"name":"icon_image","label":"Icon Image","type":"media","description":"Select image icon.","condition":{"icon_type":"image"}},{"name":"align","label":"Alignment","type":"choose","control_type":"responsive","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"},"justify":{"title":"Justified","icon":"eicon-text-align-justify"}},"selectors":{"{{WRAPPER}} .pxl-counter1 .pxl-counter--inner":"text-align: {{VALUE}};"},"condition":{"layout":["1"]}}]},{"name":"section_style_general","label":"General","tab":"style","controls":[{"name":"effect","label":"Effect","type":"select","options":{"effect-default":"Default","effect-slide":"Slide"},"default":"effect-default"},{"name":"style_l1","label":"Style","type":"select","options":{"":"Custom","style-1":"Box Light Blue","style-2":"Style 2","style-3":"Style 3","style-4":"Style 4","style-5":"Style 5","box-shadow":"Box Shadow","box-border2":"Box White"},"default":"","condition":{"layout":"1"}},{"name":"flex_dir","label":"Direction","type":"choose","options":{"row":{"title":"Row","icon":"eicon-arrow-right"},"column":{"title":"Column","icon":"eicon-arrow-down"}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--inner":"flex-direction: {{VALUE}};"}},{"name":"justify_content","label":"Justify Content","type":"select","control_type":"responsive","default":"","options":{"":"Default","start":"Start","center":"Center","end":"End"},"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--inner":"justify-content: {{VALUE}};"}},{"name":"align_items","label":"Align Items","type":"select","control_type":"responsive","default":"","options":{"":"Default","start":"Start","center":"Center","end":"End","stretch":"Stretch"},"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--inner":"align-items: {{VALUE}};"}},{"name":"style_l2","label":"Style","type":"select","options":{"box-default":"Default","box-linear-gradient":"Box Linear Gradient","box-white":"Box White"},"default":"box-default","condition":{"layout":"2"}},{"name":"bg_color","label":"Background Color","type":"color","condition":{"style_l2!":"box-linear-gradient"},"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--container, \r\n                                {{WRAPPER}} .pxl-counter4 .pxl-counter--inner":"background-color: {{VALUE}};"}},{"name":"bg_color_gradient_from","label":"Color From","type":"color","default":"","selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--inner":"--gradient-color-from: {{VALUE}};"},"condition":{"style_l2":"box-linear-gradient"}},{"name":"bg_color_gradient_to","label":"Color To","type":"color","default":"","selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--inner":"--gradient-color-to: {{VALUE}};"},"condition":{"style_l2":"box-linear-gradient"}},{"name":"box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-counter .pxl-counter--container"},{"name":"max_width","label":"Max Width","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--inner":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"gap","label":"Gap","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--inner":"gap: {{SIZE}}{{UNIT}};"}},{"name":"inner_padding","label":"Padding","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--inner":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"inner_border_radius","label":"Border Radius","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--inner":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"section_style_title","label":"Title","tab":"style","controls":[{"name":"title_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--inner .pxl-counter--title":"color: {{VALUE}};"}},{"name":"title_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-counter .pxl-counter--inner .pxl-counter--title"},{"name":"t_width","label":"Max Width","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--inner .pxl-counter--title":"max-width: {{SIZE}}{{UNIT}};"}}]},{"name":"section_style_icon","label":"Icon","tab":"style","controls":[{"name":"icon_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--inner .pxl-counter--icon i":"color: {{VALUE}};text-fill-color: {{VALUE}};-webkit-text-fill-color: {{VALUE}};background-image: none;"}},{"name":"box_icon_color","label":"Box Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--inner .pxl-counter--icon":"background-color: {{VALUE}};"}},{"name":"box_icon_border_radius","label":"Border Radius","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--inner .pxl-counter--icon":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"box_icon_border","label":"Border","type":"border","control_type":"group","selector":"{{WRAPPER}} .pxl-counter .pxl-counter--inner .pxl-counter--icon"},{"name":"box_icon_height","label":"Box Height","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--icon":"height: {{SIZE}}{{UNIT}};"}},{"name":"box_icon_width","label":"Box Width","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--icon":"widht: {{SIZE}}{{UNIT}};"}},{"name":"icon_font_size","label":"Icon Font Size","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--icon i":"font-size: {{SIZE}}{{UNIT}};"},"condition":{"icon_type":"icon"}},{"name":"icon_space_top","label":"Top Spacer","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--icon":"padding-top: {{SIZE}}{{UNIT}};"}},{"name":"icon_space_bottom","label":"Bottom Spacer","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--icon":"margin-bottom: {{SIZE}}{{UNIT}};"},"separator":"after"}]},{"name":"section_number","label":"Number","tab":"style","controls":[{"name":"number_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--number":"color: {{VALUE}}; -webkit-text-fill-color: {{VALUE}}"}},{"name":"color_gradient","label":"Color Gradient","type":"switcher","default":"","condition":{"layout":"1"}},{"name":"color_gradient_from","label":"Color From","type":"color","default":"","selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--number":"--gradient-color-from: {{VALUE}};"},"condition":{"color_gradient!":""}},{"name":"color_gradient_to","label":"Color To","type":"color","default":"","selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--number":"--gradient-color-to: {{VALUE}};"},"condition":{"color_gradient!":""}},{"name":"number_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-counter .pxl-counter--number"},{"name":"prefix_suffix_color","label":"Prefix\/Suffix Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--number .pxl-counter--suffix, {{WRAPPER}} .pxl-counter .pxl-counter--number .pxl-counter--prefix":"color: {{VALUE}};"},"condition":{"number_color_type":["color"]}},{"name":"duration","label":"Animation Duration","type":"number","default":2000,"min":100,"step":100},{"name":"number_space_top","label":"Top Spacer","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--number":"margin-top: {{SIZE}}{{UNIT}};"}},{"name":"number_space_bottom","label":"Bottom Spacer","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter--number":"margin-bottom: {{SIZE}}{{UNIT}};"}}]},{"name":"section_animation","label":"Animation","tab":"style","condition":[],"controls":[{"name":"pxl_animate","label":"Bravis Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","bounce-top wow":"bounceTop","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipCase":"flipCase","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomInSmall":"zoomInSmall","wow zoomIn":"zoomInBig","wow zoomOut":"zoomOut","wow skewIn":"skewInLeft","wow skewInRight":"skewInRight","wow skewInBottom":"skewInBottom","wow skewInTop":"skewInTop","wow RotatingY":"RotatingY","wow PXLfadeInUp":"PXLfadeInUp","fadeInPopup":"fadeInPopup","wow pxl-expanding-line-effect":"Expanding Line Effect"},"default":""},{"name":"pxl_animate_delay","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'elementor-waypoints','jquery-numerator','pxl-counter','pxl-counter-slide','gurus-counter' );
}