<?php

class PxlPartnerCarousel_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_partner_carousel';
    protected $title = 'BR Partner Carousel';
    protected $icon = 'eicon-person';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"section_content","label":"Content","tab":"content","controls":[{"name":"img_size","label":"Image Size","type":"text","description":"Enter image size (Example: \"thumbnail\", \"medium\", \"large\", \"full\" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height))."},{"name":"partner","label":"Partner","type":"repeater","controls":[{"name":"item_animate_content","label":"CONTENT","type":"heading"},{"name":"logo_type","label":"Logo Type","type":"select","options":{"icon":"Icon","image":"Image"},"default":"image"},{"name":"logo","label":"Logo","type":"media","condition":{"logo_type":"image"}},{"name":"pxl_icon","label":"Icon","type":"icons","fa4compatibility":"icon","condition":{"logo_type":"icon"}},{"name":"link","label":"Link","type":"url","label_block":true,"default":{"url":"#"}}]}]},{"name":"section_settings_carousel","label":"Settings","tab":"settings","controls":[{"name":"col_xs","label":"Columns XS Devices","type":"select","default":"1","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_sm","label":"Columns SM Devices","type":"select","default":"2","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_md","label":"Columns MD Devices","type":"select","default":"3","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_lg","label":"Columns LG Devices","type":"select","default":"3","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_xl","label":"Columns XL Devices","type":"select","default":"3","options":{"1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}},{"name":"col_xxl","label":"Columns XXL Devices","type":"select","default":"3","options":{"1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}},{"name":"slides_to_scroll","label":"Slides to scroll","type":"select","default":"1","options":{"1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}},{"name":"arrows","label":"Show Arrows","type":"switcher","default":false},{"name":"arrow_version","label":"Arrows Style","type":"select","options":{"style-light":"Light","style-dark":"Dark"},"default":"style-light"},{"name":"arrows_label","label":"Arrows Label","type":"text","condition":{"arrows":"true"}},{"name":"pagination","label":"Show Pagination","type":"switcher","default":false},{"name":"pagination_type","label":"Pagination Type","type":"select","default":"bullets","options":{"bullets":"Bullets","fraction":"Fraction"},"condition":{"pagination":"true"}},{"name":"pause_on_hover","label":"Pause on Hover","type":"switcher","default":false},{"name":"autoplay","label":"Autoplay","type":"switcher","default":false},{"name":"autoplay_speed","label":"Autoplay Speed","type":"number","default":5000,"condition":{"autoplay":"true"}},{"name":"infinite","label":"Infinite Loop","type":"switcher","default":false},{"name":"speed","label":"Animation Speed","type":"number","default":500}]},{"name":"section_style","label":"General","tab":"style","controls":[{"name":"normal","label":"NORMAL","type":"heading"},{"name":"bg_color","label":"Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-partner-carousel .pxl-swiper-slide .pxl-item--inner":"background-color: {{VALUE}};","{{WRAPPER}} .pxl-partner-carousel .pxl-swiper-slide .text":"fill: {{VALUE}}"}},{"name":"border_radius","label":"Border Radius","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-partner-carousel .pxl-swiper-slide .pxl-item--inner":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"height","label":"Height","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-partner-carousel .pxl-item--logo":"height: {{SIZE}}{{UNIT}};"}},{"name":"divider","type":"divider"},{"name":"spacing_option","label":"SPACING","type":"heading"},{"name":"spacing","label":"On\/Off","type":"switcher","default":""},{"name":"item_spacing","label":"Value","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-partner-carousel .pxl-swiper-wrapper .pxl-swiper-slide":"padding:{{SIZE}}{{UNIT}};","{{WRAPPER}} .pxl-partner-carousel .pxl-swiper-container":"margin: -{{SIZE}}{{UNIT}};"},"condition":{"spacing!":""}},{"name":"divider1","type":"divider"},{"name":"border_option","label":"BORDER","type":"heading"},{"name":"border","label":"Show\/Hide","type":"switcher","default":"true"},{"name":"border_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-partner-carousel .pxl-swiper-slide .pxl-item--inner":"border-top-color: {{VALUE}};border-bottom-color: {{VALUE}};border-left-color: {{VALUE}};border-right-color: {{VALUE}};"},"condition":{"border!":"","spacing!":""}},{"name":"border_color1","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-partner-carousel .pxl-swiper-slide .pxl-item--inner":"border-top-color: {{VALUE}};border-bottom-color: {{VALUE}};","{{WRAPPER}} .pxl-partner-carousel .pxl-swiper-slide + .pxl-swiper-slide .pxl-item--inner":"border-left-color: {{VALUE}};"},"condition":{"border!":"","spacing":""}},{"name":"border_width","label":"With","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-partner-carousel .pxl-swiper-slide .pxl-item--inner":"border-top-width: {{SIZE}}{{UNIT}};border-bottom-width: {{SIZE}}{{UNIT}};","{{WRAPPER}} .pxl-partner-carousel .pxl-swiper-slide + .pxl-swiper-slide .pxl-item--inner ":"border-left-width: {{SIZE}}{{UNIT}};"},"condition":{"border!":""}},{"name":"divider2","type":"divider"},{"name":"item_animate_option","label":"ANIMATION","type":"heading"},{"name":"item_animate","label":"Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipCase":"flipCase","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomInSmall":"zoomInSmall","wow zoomIn":"zoomInBig","wow zoomOut":"zoomOut","wow skewIn":"skewInLeft","wow skewInRight":"skewInRight","wow skewInBottom":"skewInBottom","wow skewInTop":"skewInTop","wow RotatingY":"RotatingY","wow PXLfadeInUp":"PXLfadeInUp","wow TextOutlineAnimation":"Text Outline Animation","pxl-split-text split-in-fade":"Slip Text In Fade","pxl-split-text split-in-right":"Slip Text In Right","pxl-split-text split-in-left":"Slip Text In Left","pxl-split-text split-in-up":"Slip Text In Up","pxl-split-text split-in-down":"Slip Text In Down","pxl-split-text split-in-rotate":"Slip Text In Rotate","pxl-split-text split-in-scale":"Slip Text In Scale","wow shewDeviderBottom":"shewDeviderBottom"},"default":""},{"name":"item_animate_delay","label":"Delay","type":"text","default":"0"}]},{"name":"section_style_image","label":"Image","tab":"style","controls":[{"name":"filter_img","label":"Filter","type":"css-filter","control_type":"group","selector":"{{WRAPPER}} .pxl-partner-carousel .pxl-item--logo img"},{"name":"img_max_width","label":"Max Width","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":1,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-partner-carousel .pxl-item--logo img":"max-width: {{SIZE}}{{UNIT}};"}}]},{"name":"section_style_icon","label":"Icon","tab":"style","controls":[{"name":"icon_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-partner-carousel .pxl-swiper-slide .pxl-item--inner svg":"color: {{VALUE}};"}},{"name":"icon_w","label":"Width","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":1,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-partner-carousel .pxl-item--logo svg":"width: {{SIZE}}{{UNIT}};"}},{"name":"icon_h","label":"Height","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":1,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-partner-carousel .pxl-item--logo svg":"height: {{SIZE}}{{UNIT}};"}}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'swiper','pxl-swiper' );
}